#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
/* Generated code for model ChassisAttachmentConnectors */
namespace openplx::Vehicles::Suspensions::SingleMate::Interfaces {
    /**
     * This trait extends a Mate with the chassis-attachment interface.
     *
     * A Suspensions.Interactions.Mate defines a single constraint connection for attaching a surface interacting object
     * (such as a wheel, track etc) to a chassis or the world.
     * By default is has a rotating degree of freedom for a rotating wheel around the main_axis of the connectors.
     * If the Vehicles.Suspensions.Properties.Steering trait is given to the owning Suspension, that opens up a second degree of freedom,
     * orthogonal to the wheel axis along the normal, so that a Steering interaction can be introduced.
     *
     * chassis_connector    - The connector that is relative the chassis, and defines the geometry for the suspension.
     * attachment_connector - A reference to the object that is attached to the chassis by the suspension
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT ChassisAttachmentConnectors {
        public:
            ChassisAttachmentConnectors();
            virtual ~ChassisAttachmentConnectors();
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> chassis_connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> attachment_connector() const = 0;
    };
}
