#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Signals/AngleInputTrait.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngleInput.h>
#include <openplx/Physics/Signals/AngleOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::Vehicles::Steering::Kinematic::Interactions {
    /**
     * Base class for various steering mechanisms, given two SingleMate Suspensions
     * both having the compatible steering trait.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT Base : public openplx::Physics::Interactions::Interaction1DOF, public openplx::Physics::Signals::AngleInputTrait, public openplx::Physics::Signals::AngleOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::AngleInput> m_steering_angle_input;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_steering_angle_output;

        public:
            Base();
            virtual ~Base();
            std::shared_ptr<openplx::Physics::Signals::AngleInput> steering_angle_input() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> steering_angle_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
