#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/MachineModeling/Actuators/Linear/Base.h>
#include <openplx/MachineModeling/Actuators/Linear/Connections/Base.h>
/* Generated code for model DualActuator */
namespace openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces {
    class OPENPLX_Vehicles_BUNDLE_EXPORT DualActuator {
        public:
            DualActuator();
            virtual ~DualActuator();
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> left_actuator_connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> right_actuator_connector() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> left_actuator() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> right_actuator() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> left_actuator_connection() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> right_actuator_connection() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> left_front_connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> right_front_connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> left_rear_connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> right_rear_connector() const = 0;
    };
}
