#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Simulation/SimulationBundleExport.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/System.h>
#include <openplx/Physics/Bodies/Body.h>
#include <openplx/Physics/Geometries/ContactGeometry.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CollisionGroup */
namespace openplx::Simulation {
    class OPENPLX_Simulation_BUNDLE_EXPORT CollisionGroup : public openplx::Core::Object {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::System>> m_systems;
            std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>> m_bodies;
            std::vector<std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>> m_geometries;

        public:
            CollisionGroup();
            virtual ~CollisionGroup();
            std::vector<std::shared_ptr<openplx::Physics::System>> systems() const;
            std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>> bodies() const;
            std::vector<std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>> geometries() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
