#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>
#include <openplx/Sensors/PulsedLidarLogic.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TIM781 */
namespace openplx::Sensors::Library::LIDARs::SICK {
    /**
     *         SICK TIM781 LIDAR.
     *         Data sheet: https://www.sick.com/media/pdf/8/48/148/dataSheet_TIM781-2174101_1096807_en.pdf
     *         User manual: https://www.sick.com/media/docs/5/05/905/operating_instructions_tim781_en_im0082905.pdf
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT TIM781 : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_connector;
            std::shared_ptr<openplx::Sensors::PulsedLidarLogic> m_logic;

        public:
            TIM781();
            virtual ~TIM781();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> connector() const;
            std::shared_ptr<openplx::Sensors::PulsedLidarLogic> logic() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
