#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/System.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model StructuralComponent */
namespace openplx::Physics3D {
    /**
     * Work In Progress
     *
     * The StructuralComponent a generic type that is recommented to use as a sub system
     * of a vehicle or another type of heavy machine.
     * A vehicle could consist of many structural components structured hierarchically.
     * The main purpose of the StructuralComponent is to enable a higher level
     * interface for connecting parts of a vehicle.
     * Instead of having one Mate for each pair of mate connectors,
     * we could connect Structural components with StructuralMates (not defined yet).
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT StructuralComponent : public openplx::Physics3D::System {
        protected:

        public:
            StructuralComponent();
            virtual ~StructuralComponent();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
