#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/SurfaceContact/Model.h>
#include <openplx/Physics/Interactions/SurfaceContact/PatchElasticity.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model PatchElasticityDryFrictionModel */
namespace openplx::Physics3D::Interactions::SurfaceContact {
    /**
     *     The PatchElasticityDryFrictionModel is a surface constact definition.
     *     An elastic contact normal model with dry friction.
     *     The stiffness of the elastic part must be specified.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT PatchElasticityDryFrictionModel : public openplx::Physics::Interactions::SurfaceContact::Model {
        protected:

        public:
            PatchElasticityDryFrictionModel();
            virtual ~PatchElasticityDryFrictionModel();
            std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity> normal_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction> friction() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
