#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/VelocityMotor.h>
#include <openplx/Physics/Signals/Force1DOutputTrait.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutputTrait.h>
#include <openplx/Physics/Signals/LinearVelocity1DInputTrait.h>
#include <openplx/Physics/Signals/ForceRangeInputTrait.h>
#include <openplx/Physics/Signals/ForceRangeOutputTrait.h>
#include <openplx/Physics/Signals/Force1DOutput.h>
#include <openplx/Physics/Signals/LinearVelocity1DInput.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutput.h>
#include <openplx/Physics/Signals/ForceRangeInput.h>
#include <openplx/Physics/Signals/ForceRangeOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LinearVelocityMotor */
namespace openplx::Physics3D::Interactions {
    class OPENPLX_Physics3D_BUNDLE_EXPORT LinearVelocityMotor : public openplx::Physics3D::Interactions::VelocityMotor, public openplx::Physics::Signals::Force1DOutputTrait, public openplx::Physics::Signals::LinearVelocity1DOutputTrait, public openplx::Physics::Signals::LinearVelocity1DInputTrait, public openplx::Physics::Signals::ForceRangeInputTrait, public openplx::Physics::Signals::ForceRangeOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> m_force_output;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput> m_target_linear_velocity_input;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> m_target_linear_velocity_output;
            std::shared_ptr<openplx::Physics::Signals::ForceRangeInput> m_force_range_input;
            std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput> m_force_range_output;

        public:
            LinearVelocityMotor();
            virtual ~LinearVelocityMotor();
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> force_output() const;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput> target_linear_velocity_input() const;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> target_linear_velocity_output() const;
            std::shared_ptr<openplx::Physics::Signals::ForceRangeInput> force_range_input() const;
            std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput> force_range_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
