#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Bodies/Body.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DInputTrait.h>
#include <openplx/Physics3D/Signals/AngularVelocity3DInputTrait.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DOutputTrait.h>
#include <openplx/Physics3D/Signals/AngularVelocity3DOutputTrait.h>
#include <openplx/Physics3D/Signals/Position3DOutputTrait.h>
#include <openplx/Physics3D/Signals/RPYOutputTrait.h>
#include <openplx/Physics3D/Bodies/Inertia.h>
#include <openplx/Physics3D/Bodies/RigidBodyKinematics.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DOutput.h>
#include <openplx/Physics3D/Signals/AngularVelocity3DOutput.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DInput.h>
#include <openplx/Physics3D/Signals/AngularVelocity3DInput.h>
#include <openplx/Physics3D/Signals/Position3DOutput.h>
#include <openplx/Physics3D/Signals/RPYOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RigidBody */
namespace openplx::Physics3D::Bodies {
    /**
     * By default, all bodies follow the laws of dynamics.
     * To create exceptions, you must set the is_dynamic boolean attribute to false.
     * When set to false, the body is considered kinematically controlled
     * their motion is defined by explicit velocities specified in the kinematics attribute of the body.
     * is_dynamic - indicates wheather the rigid body is dynamic.
     *             The rigid body is expected to be kinematically controlled if set to false.
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT RigidBody : public openplx::Physics3D::Bodies::Body, public openplx::Physics3D::Signals::LinearVelocity3DInputTrait, public openplx::Physics3D::Signals::AngularVelocity3DInputTrait, public openplx::Physics3D::Signals::LinearVelocity3DOutputTrait, public openplx::Physics3D::Signals::AngularVelocity3DOutputTrait, public openplx::Physics3D::Signals::Position3DOutputTrait, public openplx::Physics3D::Signals::RPYOutputTrait {
        protected:
            bool m_is_dynamic;
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput> m_linear_velocity_world_output;
            std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput> m_angular_velocity_world_output;
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput> m_linear_velocity_world_input;
            std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput> m_angular_velocity_world_input;
            std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput> m_position_output;
            std::shared_ptr<openplx::Physics3D::Signals::RPYOutput> m_rpy_output;

        public:
            RigidBody();
            virtual ~RigidBody();
            std::shared_ptr<openplx::Physics3D::Bodies::Inertia> inertia() const;
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics> kinematics() const;
            bool is_dynamic() const;
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput> linear_velocity_world_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput> angular_velocity_world_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput> linear_velocity_world_input() const;
            std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput> angular_velocity_world_input() const;
            std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput> position_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::RPYOutput> rpy_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
