#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Actuators/Linear/Connections/Base.h>
#include <openplx/MachineModeling/Actuators/Linear/Distance.h>
#include <openplx/Physics3D/Interactions/DistanceRange.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Distance */
namespace openplx::MachineModeling::Actuators::Linear::Connections {
    /**
     *     Defines a DistanceMotor between the ground and drive.
     *     The range is limited between min_length and max_length = stroke_length + min_length
     **/
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Distance : public openplx::MachineModeling::Actuators::Linear::Connections::Base {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::DistanceRange> m_range;

        public:
            Distance();
            virtual ~Distance();
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance> actuator() const;
            std::shared_ptr<openplx::Physics3D::Interactions::DistanceRange> range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
