%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::MachineModeling::Actuators::Linear::Base;
%nspace openplx::MachineModeling::Actuators::Linear::Connections::Base;
%nspace openplx::MachineModeling::Actuators::Linear::Connections::Cylinder;
%nspace openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings;
%nspace openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings;
%nspace openplx::MachineModeling::Actuators::Linear::Connections::Distance;
%nspace openplx::MachineModeling::Actuators::Linear::Cylinder;
%nspace openplx::MachineModeling::Actuators::Linear::CylinderBearings;
%nspace openplx::MachineModeling::Actuators::Linear::CylinderPart;
%nspace openplx::MachineModeling::Actuators::Linear::Distance;
%nspace openplx::MachineModeling::Actuators::Linear::Traits::CylinderVisual;
%nspace openplx::MachineModeling::Actuators::Linear::Traits::ForceMotor;
%nspace openplx::MachineModeling::Actuators::Linear::Traits::RigidCylinderPart;
%nspace openplx::MachineModeling::Actuators::Linear::Traits::VelocityMotor;
%nspace openplx::MachineModeling::Bearings::Base;
%nspace openplx::MachineModeling::Bearings::Pair;
%nspace openplx::MachineModeling::Components::Composite::Base;
%nspace openplx::MachineModeling::Components::Composite::LinkPair;
%nspace openplx::MachineModeling::Components::Primitive::Axle::Base;
%nspace openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical;
%nspace openplx::MachineModeling::Components::Primitive::Axle::Traits::Cylindrical;
%nspace openplx::MachineModeling::Components::Primitive::Base;
%nspace openplx::MachineModeling::Components::Primitive::Link::Base;
%nspace openplx::MachineModeling::Connections::Base;
%nspace openplx::MachineModeling::Connections::Interfaces::FromTo;
%nspace openplx::MachineModeling::Connections::Pivot::AxleBearings;
%nspace openplx::MachineModeling::Connections::Pivot::Base;
%nspace openplx::MachineModeling::Connections::Pivot::Bearings;
%nspace openplx::MachineModeling::Connections::Pivot::Hinge;
%nspace openplx::MachineModeling::Connections::Pivot::HingedAxle;
%nspace openplx::MachineModeling::Connections::Pivot::LockedAxleBearings;
%nspace openplx::MachineModeling::Connections::Pivot::LockedBearings;
%nspace openplx::MachineModeling::Connections::Pivot::Traits::Axle;
%nspace openplx::MachineModeling::Connections::Pivot::Traits::Bearings;
%nspace openplx::MachineModeling::Connections::Universal::Base;
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Base);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Base);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Cylinder);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Distance);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Cylinder);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::CylinderBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::CylinderPart);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Distance);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Traits::CylinderVisual);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Traits::ForceMotor);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Traits::RigidCylinderPart);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Traits::VelocityMotor);
%shared_ptr(openplx::MachineModeling::Bearings::Base);
%shared_ptr(openplx::MachineModeling::Bearings::Pair);
%shared_ptr(openplx::MachineModeling::Components::Composite::Base);
%shared_ptr(openplx::MachineModeling::Components::Composite::LinkPair);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Axle::Base);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Axle::Traits::Cylindrical);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Base);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Link::Base);
%shared_ptr(openplx::MachineModeling::Connections::Base);
%shared_ptr(openplx::MachineModeling::Connections::Interfaces::FromTo);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::AxleBearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Base);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Bearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Hinge);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::HingedAxle);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::LockedAxleBearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::LockedBearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Traits::Axle);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Traits::Bearings);
%shared_ptr(openplx::MachineModeling::Connections::Universal::Base);
OPENPLX_TRAIT(CylinderVisual_TraitProxy, CylinderVisual, openplx::MachineModeling::Actuators::Linear::Traits::CylinderVisual);
OPENPLX_TRAIT(ForceMotor_TraitProxy, ForceMotor, openplx::MachineModeling::Actuators::Linear::Traits::ForceMotor);
OPENPLX_TRAIT(RigidCylinderPart_TraitProxy, RigidCylinderPart, openplx::MachineModeling::Actuators::Linear::Traits::RigidCylinderPart);
OPENPLX_TRAIT(VelocityMotor_TraitProxy, VelocityMotor, openplx::MachineModeling::Actuators::Linear::Traits::VelocityMotor);
OPENPLX_TRAIT(Cylindrical_TraitProxy, Cylindrical, openplx::MachineModeling::Components::Primitive::Axle::Traits::Cylindrical);
OPENPLX_TRAIT(FromTo_TraitProxy, FromTo, openplx::MachineModeling::Connections::Interfaces::FromTo);
OPENPLX_TRAIT(Axle_TraitProxy, Axle, openplx::MachineModeling::Connections::Pivot::Traits::Axle);
OPENPLX_TRAIT(Bearings_TraitProxy, Bearings, openplx::MachineModeling::Connections::Pivot::Traits::Bearings);
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Connections::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Connections::Cylinder)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Connections::Distance)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Cylinder)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::CylinderBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::CylinderPart)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Actuators::Linear::Distance)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Bearings::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Bearings::Pair)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Composite::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Composite::LinkPair)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Primitive::Axle::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Primitive::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Components::Primitive::Link::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::AxleBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::Base)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::Bearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::Hinge)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::HingedAxle)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::LockedAxleBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Pivot::LockedBearings)
OPENPLX_FIX_DOWNCASTING(openplx::MachineModeling::Connections::Universal::Base)
%typemap(csimports) openplx::MachineModeling::Actuators::Linear::Connections::Base "
/* Workaround for missing namespaces on interfaces */
using FromTo = openplx.MachineModeling.Connections.Interfaces.FromTo;
";
%typemap(csimports) openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical "
/* Workaround for missing namespaces on interfaces */
using Cylindrical = openplx.MachineModeling.Components.Primitive.Axle.Traits.Cylindrical;
";
%typemap(csimports) openplx::MachineModeling::Connections::Pivot::AxleBearings "
/* Workaround for missing namespaces on interfaces */
using Bearings = openplx.MachineModeling.Connections.Pivot.Traits.Bearings;
";
%typemap(csimports) openplx::MachineModeling::Connections::Pivot::Base "
/* Workaround for missing namespaces on interfaces */
using FromTo = openplx.MachineModeling.Connections.Interfaces.FromTo;
";
%typemap(csimports) openplx::MachineModeling::Connections::Pivot::Bearings "
/* Workaround for missing namespaces on interfaces */
using Bearings = openplx.MachineModeling.Connections.Pivot.Traits.Bearings;
";
%typemap(csimports) openplx::MachineModeling::Connections::Pivot::HingedAxle "
/* Workaround for missing namespaces on interfaces */
using Axle = openplx.MachineModeling.Connections.Pivot.Traits.Axle;
";
%typemap(csimports) openplx::MachineModeling::Connections::Universal::Base "
/* Workaround for missing namespaces on interfaces */
using FromTo = openplx.MachineModeling.Connections.Interfaces.FromTo;
";
%include "openplx/MachineModeling/Components/Composite/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/Base.h"
%include "openplx/MachineModeling/Connections/Base.h"
%include "openplx/MachineModeling/Connections/Interfaces/FromTo.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Cylinder.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderAxleBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Distance.h"
%include "openplx/MachineModeling/Actuators/Linear/Cylinder.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderBearings.h"
%include "openplx/MachineModeling/Components/Primitive/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderPart.h"
%include "openplx/MachineModeling/Actuators/Linear/Distance.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/CylinderVisual.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/ForceMotor.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/RigidCylinderPart.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/VelocityMotor.h"
%include "openplx/MachineModeling/Bearings/Base.h"
%include "openplx/MachineModeling/Bearings/Pair.h"
%include "openplx/MachineModeling/Components/Composite/LinkPair.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/Traits/Cylindrical.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/RigidCylindrical.h"
%include "openplx/MachineModeling/Components/Primitive/Link/Base.h"
%include "openplx/MachineModeling/Connections/Pivot/Base.h"
%include "openplx/MachineModeling/Connections/Pivot/Hinge.h"
%include "openplx/MachineModeling/Connections/Pivot/Traits/Axle.h"
%include "openplx/MachineModeling/Connections/Pivot/HingedAxle.h"
%include "openplx/MachineModeling/Connections/Pivot/Traits/Bearings.h"
%include "openplx/MachineModeling/Connections/Pivot/AxleBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/Bearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedAxleBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedBearings.h"
%include "openplx/MachineModeling/Connections/Universal/Base.h"
%ignore MachineModeling_register_factories;
%include <openplx/MachineModeling/MachineModeling_all.h>
%inline {
    void MachineModeling_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        MachineModeling_register_factories(eval_ctx);
    }
}
%template(MachineModelingActuatorsLinearBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>>;
%template(MachineModelingActuatorsLinearConnectionsBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>>;
%template(MachineModelingActuatorsLinearConnectionsCylinderVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>>;
%template(MachineModelingActuatorsLinearConnectionsCylinderAxleBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>>;
%template(MachineModelingActuatorsLinearConnectionsCylinderBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>>;
%template(MachineModelingActuatorsLinearConnectionsDistanceVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>>;
%template(MachineModelingActuatorsLinearCylinderVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>>;
%template(MachineModelingActuatorsLinearCylinderBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>>;
%template(MachineModelingActuatorsLinearCylinderPartVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>>;
%template(MachineModelingActuatorsLinearDistanceVector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>>;
%template(MachineModelingBearingsBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Base>>;
%template(MachineModelingBearingsPairVector) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Pair>>;
%template(MachineModelingComponentsCompositeBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>>;
%template(MachineModelingComponentsCompositeLinkPairVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>>;
%template(MachineModelingComponentsPrimitiveAxleBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>>;
%template(MachineModelingComponentsPrimitiveAxleRigidCylindricalVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>>;
%template(MachineModelingComponentsPrimitiveBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>>;
%template(MachineModelingComponentsPrimitiveLinkBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>>;
%template(MachineModelingConnectionsBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Base>>;
%template(MachineModelingConnectionsPivotAxleBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>>;
%template(MachineModelingConnectionsPivotBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>>;
%template(MachineModelingConnectionsPivotBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>>;
%template(MachineModelingConnectionsPivotHingeVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>>;
%template(MachineModelingConnectionsPivotHingedAxleVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>>;
%template(MachineModelingConnectionsPivotLockedAxleBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>>;
%template(MachineModelingConnectionsPivotLockedBearingsVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>>;
%template(MachineModelingConnectionsUniversalBaseVector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearBase, openplx::MachineModeling::Actuators::Linear::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearConnectionsBase, openplx::MachineModeling::Actuators::Linear::Connections::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearConnectionsCylinder, openplx::MachineModeling::Actuators::Linear::Connections::Cylinder)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearConnectionsCylinderAxleBearings, openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearConnectionsCylinderBearings, openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearConnectionsDistance, openplx::MachineModeling::Actuators::Linear::Connections::Distance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearCylinder, openplx::MachineModeling::Actuators::Linear::Cylinder)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearCylinderBearings, openplx::MachineModeling::Actuators::Linear::CylinderBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearCylinderPart, openplx::MachineModeling::Actuators::Linear::CylinderPart)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingActuatorsLinearDistance, openplx::MachineModeling::Actuators::Linear::Distance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingBearingsBase, openplx::MachineModeling::Bearings::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingBearingsPair, openplx::MachineModeling::Bearings::Pair)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsCompositeBase, openplx::MachineModeling::Components::Composite::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsCompositeLinkPair, openplx::MachineModeling::Components::Composite::LinkPair)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsPrimitiveAxleBase, openplx::MachineModeling::Components::Primitive::Axle::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsPrimitiveAxleRigidCylindrical, openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsPrimitiveBase, openplx::MachineModeling::Components::Primitive::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingComponentsPrimitiveLinkBase, openplx::MachineModeling::Components::Primitive::Link::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsBase, openplx::MachineModeling::Connections::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotAxleBearings, openplx::MachineModeling::Connections::Pivot::AxleBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotBase, openplx::MachineModeling::Connections::Pivot::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotBearings, openplx::MachineModeling::Connections::Pivot::Bearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotHinge, openplx::MachineModeling::Connections::Pivot::Hinge)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotHingedAxle, openplx::MachineModeling::Connections::Pivot::HingedAxle)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotLockedAxleBearings, openplx::MachineModeling::Connections::Pivot::LockedAxleBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsPivotLockedBearings, openplx::MachineModeling::Connections::Pivot::LockedBearings)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalMachineModelingConnectionsUniversalBase, openplx::MachineModeling::Connections::Universal::Base)
