%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::DriveTrain::Actuator;
%nspace openplx::DriveTrain::AutomaticBrake;
%nspace openplx::DriveTrain::AutomaticClutch;
%nspace openplx::DriveTrain::Differential;
%nspace openplx::DriveTrain::EmpiricalEngine;
%nspace openplx::DriveTrain::EmpiricalTorqueConverter;
%nspace openplx::DriveTrain::Engines::CatC17520;
%nspace openplx::DriveTrain::Engines::CatC27;
%nspace openplx::DriveTrain::Engines::CatC32ACERT;
%nspace openplx::DriveTrain::Engines::DoosanDE08TIS;
%nspace openplx::DriveTrain::Engines::GMTruck;
%nspace openplx::DriveTrain::Engines::JohnDeere6068HF485;
%nspace openplx::DriveTrain::Engines::KomatsuWA47510;
%nspace openplx::DriveTrain::Engines::SaabB234i;
%nspace openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5;
%nspace openplx::DriveTrain::Engines::VolvoBMTD45B;
%nspace openplx::DriveTrain::Engines::VolvoD16E540;
%nspace openplx::DriveTrain::Engines::VolvoT5;
%nspace openplx::DriveTrain::Engines::VolvoTD73KD;
%nspace openplx::DriveTrain::FlexibleGear;
%nspace openplx::DriveTrain::Gear;
%nspace openplx::DriveTrain::GearBox;
%nspace openplx::DriveTrain::HingeActuator;
%nspace openplx::DriveTrain::InfinitePowerSource;
%nspace openplx::DriveTrain::ManualBrake;
%nspace openplx::DriveTrain::ManualClutch;
%nspace openplx::DriveTrain::MeanValueEngine;
%nspace openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate;
%nspace openplx::DriveTrain::PowerSource;
%nspace openplx::DriveTrain::PrismaticActuator;
%nspace openplx::DriveTrain::RPMTorquePair;
%nspace openplx::DriveTrain::Shaft;
%nspace openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterLockUpInput;
%nspace openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput;
%nspace openplx::DriveTrain::TorqueLimitedSlipDifferential;
%nspace openplx::DriveTrain::TorqueMotor;
%nspace openplx::DriveTrain::Traits::FourStrokeEngine;
%nspace openplx::DriveTrain::Traits::PowerGenerator;
%nspace openplx::DriveTrain::Traits::RotationalPowerGenerator;
%nspace openplx::DriveTrain::Traits::TwoStrokeEngine;
%nspace openplx::DriveTrain::VelocityRatioGeometryFactorPair;
%nspace openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair;
%nspace openplx::DriveTrain::ViscousGear;
%shared_ptr(openplx::DriveTrain::Actuator);
%shared_ptr(openplx::DriveTrain::AutomaticBrake);
%shared_ptr(openplx::DriveTrain::AutomaticClutch);
%shared_ptr(openplx::DriveTrain::Differential);
%shared_ptr(openplx::DriveTrain::EmpiricalEngine);
%shared_ptr(openplx::DriveTrain::EmpiricalTorqueConverter);
%shared_ptr(openplx::DriveTrain::Engines::CatC17520);
%shared_ptr(openplx::DriveTrain::Engines::CatC27);
%shared_ptr(openplx::DriveTrain::Engines::CatC32ACERT);
%shared_ptr(openplx::DriveTrain::Engines::DoosanDE08TIS);
%shared_ptr(openplx::DriveTrain::Engines::GMTruck);
%shared_ptr(openplx::DriveTrain::Engines::JohnDeere6068HF485);
%shared_ptr(openplx::DriveTrain::Engines::KomatsuWA47510);
%shared_ptr(openplx::DriveTrain::Engines::SaabB234i);
%shared_ptr(openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5);
%shared_ptr(openplx::DriveTrain::Engines::VolvoBMTD45B);
%shared_ptr(openplx::DriveTrain::Engines::VolvoD16E540);
%shared_ptr(openplx::DriveTrain::Engines::VolvoT5);
%shared_ptr(openplx::DriveTrain::Engines::VolvoTD73KD);
%shared_ptr(openplx::DriveTrain::FlexibleGear);
%shared_ptr(openplx::DriveTrain::Gear);
%shared_ptr(openplx::DriveTrain::GearBox);
%shared_ptr(openplx::DriveTrain::HingeActuator);
%shared_ptr(openplx::DriveTrain::InfinitePowerSource);
%shared_ptr(openplx::DriveTrain::ManualBrake);
%shared_ptr(openplx::DriveTrain::ManualClutch);
%shared_ptr(openplx::DriveTrain::MeanValueEngine);
%shared_ptr(openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate);
%shared_ptr(openplx::DriveTrain::PowerSource);
%shared_ptr(openplx::DriveTrain::PrismaticActuator);
%shared_ptr(openplx::DriveTrain::RPMTorquePair);
%shared_ptr(openplx::DriveTrain::Shaft);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockUpInput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput);
%shared_ptr(openplx::DriveTrain::TorqueLimitedSlipDifferential);
%shared_ptr(openplx::DriveTrain::TorqueMotor);
%shared_ptr(openplx::DriveTrain::Traits::FourStrokeEngine);
%shared_ptr(openplx::DriveTrain::Traits::PowerGenerator);
%shared_ptr(openplx::DriveTrain::Traits::RotationalPowerGenerator);
%shared_ptr(openplx::DriveTrain::Traits::TwoStrokeEngine);
%shared_ptr(openplx::DriveTrain::VelocityRatioGeometryFactorPair);
%shared_ptr(openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair);
%shared_ptr(openplx::DriveTrain::ViscousGear);
OPENPLX_TRAIT(FourStrokeEngine_TraitProxy, FourStrokeEngine, openplx::DriveTrain::Traits::FourStrokeEngine);
OPENPLX_TRAIT(PowerGenerator_TraitProxy, PowerGenerator, openplx::DriveTrain::Traits::PowerGenerator);
OPENPLX_TRAIT(RotationalPowerGenerator_TraitProxy, RotationalPowerGenerator, openplx::DriveTrain::Traits::RotationalPowerGenerator);
OPENPLX_TRAIT(TwoStrokeEngine_TraitProxy, TwoStrokeEngine, openplx::DriveTrain::Traits::TwoStrokeEngine);
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Actuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::AutomaticBrake)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::AutomaticClutch)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Differential)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::EmpiricalEngine)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::EmpiricalTorqueConverter)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::CatC17520)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::CatC27)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::CatC32ACERT)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::DoosanDE08TIS)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::GMTruck)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::JohnDeere6068HF485)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::KomatsuWA47510)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::SaabB234i)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::VolvoBMTD45B)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::VolvoD16E540)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::VolvoT5)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Engines::VolvoTD73KD)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::FlexibleGear)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Gear)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::GearBox)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::HingeActuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::InfinitePowerSource)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ManualBrake)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ManualClutch)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::MeanValueEngine)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::PowerSource)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::PrismaticActuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::RPMTorquePair)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Shaft)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterLockUpInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::TorqueLimitedSlipDifferential)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::TorqueMotor)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::VelocityRatioGeometryFactorPair)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ViscousGear)
%typemap(csimports) openplx::DriveTrain::AutomaticBrake "
/* Workaround for missing namespaces on interfaces */
using DurationInputTrait = openplx.Physics.Signals.DurationInputTrait;
using DurationOutputTrait = openplx.Physics.Signals.DurationOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::AutomaticClutch "
/* Workaround for missing namespaces on interfaces */
using DurationInputTrait = openplx.Physics.Signals.DurationInputTrait;
using DurationOutputTrait = openplx.Physics.Signals.DurationOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::EmpiricalEngine "
/* Workaround for missing namespaces on interfaces */
using PowerGenerator = openplx.DriveTrain.Traits.PowerGenerator;
using RotationalPowerGenerator = openplx.DriveTrain.Traits.RotationalPowerGenerator;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using RpmOutputTrait = openplx.Physics.Signals.RpmOutputTrait;
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::EmpiricalTorqueConverter "
/* Workaround for missing namespaces on interfaces */
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::Gear "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::GearBox "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using IntInputTrait = openplx.Physics.Signals.IntInputTrait;
using IntOutputTrait = openplx.Physics.Signals.IntOutputTrait;
using RatioOutputTrait = openplx.Physics.Signals.RatioOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::ManualBrake "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::ManualClutch "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::MeanValueEngine "
/* Workaround for missing namespaces on interfaces */
using PowerGenerator = openplx.DriveTrain.Traits.PowerGenerator;
using RotationalPowerGenerator = openplx.DriveTrain.Traits.RotationalPowerGenerator;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using RpmOutputTrait = openplx.Physics.Signals.RpmOutputTrait;
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::TorqueMotor "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using Torque1DInputTrait = openplx.Physics.Signals.Torque1DInputTrait;
";
%typemap(csimports) openplx::DriveTrain::Traits::RotationalPowerGenerator "
/* Workaround for missing namespaces on interfaces */
";
%include "openplx/DriveTrain/Actuator.h"
%include "openplx/DriveTrain/ManualBrake.h"
%include "openplx/DriveTrain/AutomaticBrake.h"
%include "openplx/DriveTrain/ManualClutch.h"
%include "openplx/DriveTrain/AutomaticClutch.h"
%include "openplx/DriveTrain/Differential.h"
%include "openplx/DriveTrain/Traits/PowerGenerator.h"
%include "openplx/DriveTrain/Traits/RotationalPowerGenerator.h"
%include "openplx/DriveTrain/EmpiricalEngine.h"
%include "openplx/DriveTrain/EmpiricalTorqueConverter.h"
%include "openplx/DriveTrain/MeanValueEngine.h"
%include "openplx/DriveTrain/Engines/CatC17520.h"
%include "openplx/DriveTrain/Engines/CatC27.h"
%include "openplx/DriveTrain/Engines/CatC32ACERT.h"
%include "openplx/DriveTrain/Engines/DoosanDE08TIS.h"
%include "openplx/DriveTrain/Engines/GMTruck.h"
%include "openplx/DriveTrain/Engines/JohnDeere6068HF485.h"
%include "openplx/DriveTrain/Engines/KomatsuWA47510.h"
%include "openplx/DriveTrain/Engines/SaabB234i.h"
%include "openplx/DriveTrain/Engines/ScaniaK310UB4X2Euro5.h"
%include "openplx/DriveTrain/Engines/VolvoBMTD45B.h"
%include "openplx/DriveTrain/Engines/VolvoD16E540.h"
%include "openplx/DriveTrain/Engines/VolvoT5.h"
%include "openplx/DriveTrain/Engines/VolvoTD73KD.h"
%include "openplx/DriveTrain/Gear.h"
%include "openplx/DriveTrain/FlexibleGear.h"
%include "openplx/DriveTrain/GearBox.h"
%include "openplx/DriveTrain/HingeActuator.h"
%include "openplx/DriveTrain/PowerSource.h"
%include "openplx/DriveTrain/InfinitePowerSource.h"
%include "openplx/DriveTrain/MechanicalDriveTrains/TwoWheelTemplate.h"
%include "openplx/DriveTrain/PrismaticActuator.h"
%include "openplx/DriveTrain/RPMTorquePair.h"
%include "openplx/DriveTrain/Shaft.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockUpInput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockedUpOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterPumpTorqueOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterTurbineTorqueOutput.h"
%include "openplx/DriveTrain/TorqueLimitedSlipDifferential.h"
%include "openplx/DriveTrain/TorqueMotor.h"
%include "openplx/DriveTrain/Traits/FourStrokeEngine.h"
%include "openplx/DriveTrain/Traits/TwoStrokeEngine.h"
%include "openplx/DriveTrain/VelocityRatioGeometryFactorPair.h"
%include "openplx/DriveTrain/VelocityRatioTorqueMultiplicationPair.h"
%include "openplx/DriveTrain/ViscousGear.h"
%ignore DriveTrain_register_factories;
%include <openplx/DriveTrain/DriveTrain_all.h>
%inline {
    void DriveTrain_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        DriveTrain_register_factories(eval_ctx);
    }
}
%template(DriveTrainActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::Actuator>>;
%template(DriveTrainAutomaticBrakeVector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticBrake>>;
%template(DriveTrainAutomaticClutchVector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticClutch>>;
%template(DriveTrainDifferentialVector) std::vector<std::shared_ptr<openplx::DriveTrain::Differential>>;
%template(DriveTrainEmpiricalEngineVector) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>>;
%template(DriveTrainEmpiricalTorqueConverterVector) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>>;
%template(DriveTrainEnginesCatC17520Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>>;
%template(DriveTrainEnginesCatC27Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC27>>;
%template(DriveTrainEnginesCatC32ACERTVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>>;
%template(DriveTrainEnginesDoosanDE08TISVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>>;
%template(DriveTrainEnginesGMTruckVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>>;
%template(DriveTrainEnginesJohnDeere6068HF485Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>>;
%template(DriveTrainEnginesKomatsuWA47510Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>>;
%template(DriveTrainEnginesSaabB234iVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>>;
%template(DriveTrainEnginesScaniaK310UB4X2Euro5Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>>;
%template(DriveTrainEnginesVolvoBMTD45BVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>>;
%template(DriveTrainEnginesVolvoD16E540Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>>;
%template(DriveTrainEnginesVolvoT5Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>>;
%template(DriveTrainEnginesVolvoTD73KDVector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>>;
%template(DriveTrainFlexibleGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::FlexibleGear>>;
%template(DriveTrainGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::Gear>>;
%template(DriveTrainGearBoxVector) std::vector<std::shared_ptr<openplx::DriveTrain::GearBox>>;
%template(DriveTrainHingeActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::HingeActuator>>;
%template(DriveTrainInfinitePowerSourceVector) std::vector<std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>>;
%template(DriveTrainManualBrakeVector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualBrake>>;
%template(DriveTrainManualClutchVector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualClutch>>;
%template(DriveTrainMeanValueEngineVector) std::vector<std::shared_ptr<openplx::DriveTrain::MeanValueEngine>>;
%template(DriveTrainMechanicalDriveTrainsTwoWheelTemplateVector) std::vector<std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>>;
%template(DriveTrainPowerSourceVector) std::vector<std::shared_ptr<openplx::DriveTrain::PowerSource>>;
%template(DriveTrainPrismaticActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::PrismaticActuator>>;
%template(DriveTrainRPMTorquePairVector) std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>>;
%template(DriveTrainShaftVector) std::vector<std::shared_ptr<openplx::DriveTrain::Shaft>>;
%template(DriveTrainSignalsAutomaticClutchDisengagementDurationInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>>;
%template(DriveTrainSignalsAutomaticClutchDisengagementDurationOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>>;
%template(DriveTrainSignalsAutomaticClutchEngagementDurationInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>>;
%template(DriveTrainSignalsAutomaticClutchEngagementDurationOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>>;
%template(DriveTrainSignalsTorqueConverterLockUpInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>>;
%template(DriveTrainSignalsTorqueConverterLockedUpOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>>;
%template(DriveTrainSignalsTorqueConverterPumpTorqueOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>>;
%template(DriveTrainSignalsTorqueConverterTurbineTorqueOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>>;
%template(DriveTrainTorqueLimitedSlipDifferentialVector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>>;
%template(DriveTrainTorqueMotorVector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueMotor>>;
%template(DriveTrainVelocityRatioGeometryFactorPairVector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>>;
%template(DriveTrainVelocityRatioTorqueMultiplicationPairVector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>>;
%template(DriveTrainViscousGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::ViscousGear>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainActuator, openplx::DriveTrain::Actuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainAutomaticBrake, openplx::DriveTrain::AutomaticBrake)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainAutomaticClutch, openplx::DriveTrain::AutomaticClutch)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainDifferential, openplx::DriveTrain::Differential)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEmpiricalEngine, openplx::DriveTrain::EmpiricalEngine)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEmpiricalTorqueConverter, openplx::DriveTrain::EmpiricalTorqueConverter)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesCatC17520, openplx::DriveTrain::Engines::CatC17520)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesCatC27, openplx::DriveTrain::Engines::CatC27)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesCatC32ACERT, openplx::DriveTrain::Engines::CatC32ACERT)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesDoosanDE08TIS, openplx::DriveTrain::Engines::DoosanDE08TIS)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesGMTruck, openplx::DriveTrain::Engines::GMTruck)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesJohnDeere6068HF485, openplx::DriveTrain::Engines::JohnDeere6068HF485)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesKomatsuWA47510, openplx::DriveTrain::Engines::KomatsuWA47510)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesSaabB234i, openplx::DriveTrain::Engines::SaabB234i)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesScaniaK310UB4X2Euro5, openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesVolvoBMTD45B, openplx::DriveTrain::Engines::VolvoBMTD45B)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesVolvoD16E540, openplx::DriveTrain::Engines::VolvoD16E540)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesVolvoT5, openplx::DriveTrain::Engines::VolvoT5)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainEnginesVolvoTD73KD, openplx::DriveTrain::Engines::VolvoTD73KD)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainFlexibleGear, openplx::DriveTrain::FlexibleGear)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainGear, openplx::DriveTrain::Gear)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainGearBox, openplx::DriveTrain::GearBox)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainHingeActuator, openplx::DriveTrain::HingeActuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainInfinitePowerSource, openplx::DriveTrain::InfinitePowerSource)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainManualBrake, openplx::DriveTrain::ManualBrake)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainManualClutch, openplx::DriveTrain::ManualClutch)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainMeanValueEngine, openplx::DriveTrain::MeanValueEngine)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainMechanicalDriveTrainsTwoWheelTemplate, openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainPowerSource, openplx::DriveTrain::PowerSource)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainPrismaticActuator, openplx::DriveTrain::PrismaticActuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainRPMTorquePair, openplx::DriveTrain::RPMTorquePair)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainShaft, openplx::DriveTrain::Shaft)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsAutomaticClutchDisengagementDurationInput, openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsAutomaticClutchDisengagementDurationOutput, openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsAutomaticClutchEngagementDurationInput, openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsAutomaticClutchEngagementDurationOutput, openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsTorqueConverterLockUpInput, openplx::DriveTrain::Signals::TorqueConverterLockUpInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsTorqueConverterLockedUpOutput, openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsTorqueConverterPumpTorqueOutput, openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainSignalsTorqueConverterTurbineTorqueOutput, openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainTorqueLimitedSlipDifferential, openplx::DriveTrain::TorqueLimitedSlipDifferential)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainTorqueMotor, openplx::DriveTrain::TorqueMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainVelocityRatioGeometryFactorPair, openplx::DriveTrain::VelocityRatioGeometryFactorPair)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainVelocityRatioTorqueMultiplicationPair, openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalDriveTrainViscousGear, openplx::DriveTrain::ViscousGear)
