/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/BitState.h>
#include <agxTerrain/ShovelSettings.h>
#include <agxTerrain/Shovel.h>
#include <agxStream/Serializable.h>

namespace agx
{
  class RigidBody;
}

namespace agxCollide
{
  class Geometry;
}

namespace agxTerrain
{
  AGX_DECLARE_POINTER_TYPES( CompositeShovel );
  AGX_DECLARE_VECTOR_TYPES( CompositeShovel );

  /**
  CompositeShovel is a base abstract class representation of Shovels types that
  consists of multiple child Shovel instances. Examples of this are:

  ClamShellBuckets, Shovel that have complex geometries.

  */
  class AGXTERRAIN_EXPORT CompositeShovel : public agxSDK::TerrainToolInstance
  {
  public:
    /**
    Default constructor.
    */
    CompositeShovel();

    /**
    Add notification when a shovel is added to a simulation.
    */
    virtual void addNotification()  override;

    /**
    Remove notification when this shovel is removed from a simulation.
    */
    virtual void removeNotification() override;

    /**
    Change state enable of this shovel. If the shovel is disabled, it can not be used for excavation in a terrain.
    Default: true.
    \param enable - true to enable, false to disable
    */
    void setEnable( bool enable );

    /**
    Access the state enable flag.
    \return true if the body is enabled (default) - otherwise false
    */
    bool getEnable() const;

    /**
    \return true if the composite shovel is valid.
    */
    virtual bool isValid() const override;

    DOXYGEN_START_INTERNAL_BLOCK()

    AGXSTREAM_DECLARE_SERIALIZABLE( agxTerrain::CompositeShovel );

    virtual void onAssemblyAdd( agxSDK::Assembly* assembly) override;

    DOXYGEN_END_INTERNAL_BLOCK()

  protected:

    bool isChildShovelsValid() const;

    enum StateFlags : agx::UInt32
    {
      ENABLED = 1 << 0
    };
    using Flags = agx::BitState<StateFlags, agx::UInt32>;

  protected:
    virtual ~CompositeShovel();
    agxTerrain::ShovelRefVector m_terrainTools;
    Flags m_flags;
  };
}
