#pragma once

#include <openplx/InputHandler.h>
#include <memory>
#include <string>
#include <optional>

namespace openplx {
    class Marshalling;

    namespace Physics::Signals {
        class Input;
        class Output;
        class AngleInput;
    }

    namespace Physics3D::Interactions {
        class TorsionSpring;
    }
}

namespace agxopenplx {

    class AgxObjectMap;
    class AgxMetadata;

    template <class InputT, typename FieldT, class... ModelT>
    class SingleFieldInputHandler : public openplx::InputHandler {
        public:
            SingleFieldInputHandler(
                std::shared_ptr<AgxObjectMap> mapper,
                std::string field_key
            );

            bool handle(
                const std::shared_ptr<openplx::Physics::Signals::Input>& input,
                const std::shared_ptr<openplx::Marshalling>& marshalling) override;

            template <class ReadModelT>
            bool write(
                const std::shared_ptr<InputT>& input,
                const std::shared_ptr<ReadModelT>& model,
                FieldT value);

        private:
            std::shared_ptr<AgxObjectMap> m_mapper;
            std::string m_field_key;
    };

    using AngleInputHandler = SingleFieldInputHandler<
        openplx::Physics::Signals::AngleInput,
        double,
        openplx::Physics3D::Interactions::TorsionSpring
    >;
}
