/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or
having been advised so by Algoryx Simulation AB for a time limited evaluation,
or having purchased a valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/


/////////////////////////////////////////////////////////////////////
// AUTOMATICALLY GENERATED, DO NOT EDIT! (except inline functions) //
/////////////////////////////////////////////////////////////////////

#ifndef AGXFN_PHYSICS_PARTITIONER_CALCULATEISLANDIMPACTS_H
#define AGXFN_PHYSICS_PARTITIONER_CALCULATEISLANDIMPACTS_H

#include <agxData/Array.h>
#include <agxData/EntityPtr.h>
#include <agx/Integer.h>
#include <agx/Real.h>
#include <agx/Math.h>
#include <agx/Job.h>
#include <agx/Physics/SolveIslandEntity.h>
#include <agx/Vec4.h>
#include <agx/Physics/SolveGroupEntity.h>
#include <agx/Physics/GraphNodeEntity.h>


namespace agx { namespace Physics { namespace Partitioner { } } }

namespace agxFn
{
  namespace Physics
  {
    namespace Partitioner
    {
      /**
      Function: Physics.Partitioner.CalculateIslandImpacts
      Implementation: (default)

      \param job The range job specifying what part of the data set to process
      \param solveIsland 
      \param graphNode 
      \param contactConstraint_isImpacting 
      \param binaryConstraint_isImpacting 
      \param manyBodyConstraint_isImpacting 
      \param particleParticleContactConstraint_isImpacting 
      \param particleBodyContactConstraint_isImpacting 
      \param granularGranularContactConstraint_isImpacting 
      \param granularBodyContactConstraint_isImpacting 
      */
      void CalculateIslandImpacts
      (
        /* Parameter list automatically generated, do not edit */
        const agx::RangeJob& job,
        agx::Physics::SolveIslandData& solveIsland,
        agx::Physics::GraphNodeData& graphNode,
        const agxData::Array< agx::Bool >& contactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& binaryConstraint_isImpacting,
        const agxData::Array< agx::Bool >& manyBodyConstraint_isImpacting,
        const agxData::Array< agx::Bool >& particleParticleContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& particleBodyContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& granularGranularContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& granularBodyContactConstraint_isImpacting
      );


      /**
      Function: Physics.Partitioner.CalculateIslandImpacts
      Implementation: ParallelPGS

      \param solveIsland 
      \param contactConstraint_isImpacting 
      \param binaryConstraint_isImpacting 
      \param manyBodyConstraint_isImpacting 
      \param particleParticleContactConstraint_isImpacting 
      \param particleBodyContactConstraint_isImpacting 
      \param granularGranularContactConstraint_isImpacting 
      \param granularBodyContactConstraint_isImpacting 
      */
      void CalculateIslandImpacts__ParallelPGS
      (
        /* Parameter list automatically generated, do not edit */
        agx::Physics::SolveIslandData& solveIsland,
        const agxData::Array< agx::Bool >& contactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& binaryConstraint_isImpacting,
        const agxData::Array< agx::Bool >& manyBodyConstraint_isImpacting,
        const agxData::Array< agx::Bool >& particleParticleContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& particleBodyContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& granularGranularContactConstraint_isImpacting,
        const agxData::Array< agx::Bool >& granularBodyContactConstraint_isImpacting
      );


    }
  }
}

#endif
