#pragma once

#include <memory>
#include <openplx/Node.h>
#include <openplx/CompositeType.h>

namespace openplx {

    class WithType : public CompositeType, public std::enable_shared_from_this<WithType>
    {
        public:
            /* Factories */
            static WithTypePtr create(
                const ModelDeclPtr& main_type,
                const std::vector<TraitImplPtr>& traits);

            /* Overrides */
            WithTypePtr asWithType() override;
            TypePtr asType() override;
            CompositeTypePtr asCompositeType() override;
            void accept(NodeVisitor& visitor) override;
            bool isAssignableTo(const TypePtr &other) override;
            std::string toString() override;
            std::string toKey() override;
            TypePtr resolve() override;
            void unbind() override;

            bool isEmpty() const override;
            VarAssignPtr findFirstMemberWithType(const std::string& name) const override;
            VarAssignPtr lookupDeclaration(const std::string& symbol_path) override;
            VarAssignPtr lookupDeclarationFromSegments(const std::vector<Token>& segments, size_t first_ix, size_t last_ix) override;

            /* Main type */
            ModelDeclPtr getMainType() const;
            void setMainType(ModelDeclPtr main_type);

            /* Traits */
            const std::vector<TraitImplPtr>& getTraits() const;
            void appendToTraits(TraitImplPtr trait);
            void collectTraits(std::unordered_set<ModelDeclPtr>& output) const;

        private:
            WithType();
            ModelDeclPtr m_main_type;
            std::vector<TraitImplPtr> m_traits;
    };
}
