#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h>
#include <openplx/Physics/Interactions/Dissipation/MechanicalDamping.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model WheelMechanicalDamping */
namespace openplx::Vehicles::Wheels::Interactions::Dissipation {
    /**
     *     Defines mechanical damping for all constrained degrees of freedom for a Wheel.
     *     */
    class OPENPLX_Vehicles_BUNDLE_EXPORT WheelMechanicalDamping : public openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation {
        protected:
            double m_default_damping;

        public:
            WheelMechanicalDamping();
            virtual ~WheelMechanicalDamping();
            double default_damping() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> along_axial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> along_radial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> around_axial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> around_radial() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
