#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultWheelDissipation */
namespace openplx::Vehicles::Wheels::Interactions::Dissipation {
    /**
     *     Defines one dissipation model for each constrained degree of freedom for a Wheel
     *     */
    class OPENPLX_Vehicles_BUNDLE_EXPORT DefaultWheelDissipation : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_along_axial;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_along_radial;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_around_axial;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_around_radial;

        public:
            DefaultWheelDissipation();
            virtual ~DefaultWheelDissipation();
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> along_axial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> along_radial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> around_axial() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> around_radial() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
