#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/CylindricalRoadWheel.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CylindricalSprocket */
namespace openplx::Vehicles::Tracks {
    /**
     * A sprocket is a profiled wheel with teeth or cogs that engage with the track chain.
     * It engages the holes in the links of the track and provides the driving force that moves the track.
     * In tracked systems, it is the sprocket that is motorized, as it performs the essential task of actually
     * propelling the vehicle forward or backward. It's often located at the front or rear of the vehicle.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT CylindricalSprocket : public openplx::Vehicles::Tracks::CylindricalRoadWheel {
        protected:

        public:
            CylindricalSprocket();
            virtual ~CylindricalSprocket();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
