#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Suspensions/Suspension.h>
#include <openplx/Vehicles/Suspensions/Interactions/Connector.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/Vehicles/Suspensions/Interactions/Mate.h>
#include <openplx/Physics3D/Interactions/LinearRange.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SingleMateSuspension */
namespace openplx::Vehicles::Suspensions {
    /**
     * The SingleMateSuspension defines a one-mate connection between
     * the chassis and an attached component for ground contact. Like a wheel, track, ski, etc.
     *
     * By default a SuspensionMate has a rotating degree of freedom for a rotating wheel around the main_axis of the connectors.
     * If the Vehicles.Suspensions.Traits.Steering trait is given to the owning Suspension that will open up a second degree of freedom,
     * orthogonal to the wheel axis along the normal. A Steering interaction can be introduced given two SteeringCompatibleSuspensions with the Steering trait.
     *
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT SingleMateSuspension : public openplx::Vehicles::Suspensions::Suspension {
        protected:
            std::weak_ptr<openplx::Vehicles::Suspensions::Interactions::Connector> m_chassis_connector;
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_attachment_connector;
            std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate> m_mate;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> m_range;

        public:
            SingleMateSuspension();
            virtual ~SingleMateSuspension();
            std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector> chassis_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> attachment_connector() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate> mate() const;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
