#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Vehicles/Suspensions/Interactions/Connector.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Mate */
namespace openplx::Vehicles::Suspensions::Interactions {
    /**
     * A Suspensions.Interactions.Mate defines a single constraint connection for attaching a surface interacting object
     * (such as a wheel, track etc) to a chassis or the world.
     * By default is has a rotating degree of freedom for a rotating wheel around the main_axis of the connectors.
     * If the Vehicles.Suspensions.Traits.Steering trait is given to the owning Suspension, that opens up a second degree of freedom,
     * orthogonal to the wheel axis along the normal, so that a Steering interaction can be introduced.
     *
     * chassis_connector    - The connector that is relative the chassis, and defines the geometry for the suspension.
     * attachment_connector - A reference to the object that is attached to the chassis by the suspension
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT Mate : public openplx::Physics3D::Interactions::Mate {
        protected:
            std::weak_ptr<openplx::Vehicles::Suspensions::Interactions::Connector> m_chassis_connector;
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_attachment_connector;

        public:
            Mate();
            virtual ~Mate();
            std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector> chassis_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> attachment_connector() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
