#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Suspensions/Interactions/Mate.h>
#include <openplx/Physics/Interactions/Dissipation/MechanicalDamping.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LinearSpringDamperMate */
namespace openplx::Vehicles::Suspensions::Interactions {
    /**
     * The LinearSpringDamperMate adds stiffness and damping parameters to the suspension mate.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT LinearSpringDamperMate : public openplx::Vehicles::Suspensions::Interactions::Mate {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> m_spring_damping;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_spring_constant;

        public:
            LinearSpringDamperMate();
            virtual ~LinearSpringDamperMate();
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> spring_damping() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> spring_constant() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
