#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Steering/Interactions/DualSuspensionSteering.h>
#include <openplx/Physics/Signals/AngleInputTrait.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngleInput.h>
#include <openplx/Physics/Signals/AngleOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RackAndPinion */
namespace openplx::Vehicles::Steering::Interactions {
    /**
     * Rack-pinion steering mechanism.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT RackAndPinion : public openplx::Vehicles::Steering::Interactions::DualSuspensionSteering, public openplx::Physics::Signals::AngleInputTrait, public openplx::Physics::Signals::AngleOutputTrait {
        protected:
            double m_initial_angle_right_tie_rod;
            double m_steering_column_distance;
            double m_rack_length;
            double m_gear;
            std::shared_ptr<openplx::Physics::Signals::AngleInput> m_steering_angle_input;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_steering_angle_output;

        public:
            RackAndPinion();
            virtual ~RackAndPinion();
            double initial_angle_right_tie_rod() const;
            double steering_column_distance() const;
            double rack_length() const;
            double gear() const;
            std::shared_ptr<openplx::Physics::Signals::AngleInput> steering_angle_input() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> steering_angle_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
