#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Terrain/TerrainBundleExport.h>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Signals/MassOutputTrait.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Math/Line.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Physics/Signals/MassOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Shovel */
namespace openplx::Terrain {
    /**
     *     A Shovel can be used to modify terrain.
     *     body - the rigid body of the shovel
     *     top_edge - a line that defines the upper edge of the shovel opening
     *     cutting_edge - a line that defines the lowest edge on the shovel opening
     *     enabled - only a enabled shovel can be used for digging in terrain
     *     tooth_direction - the direction of the digging teeth on the shovel
     *     number_teeth - number of teeth on cutting edge of the shovel
     *     tooth_min_radius - minimum radius of the shovel's teeth
     *     tooth_max_radius - minimum radius of the shovel's teeth
     *     tooth_length - length of shovel's teeth
     *
     *     Example:
     *
     *     Scene is Physics3D.System:
     *         shovel_body is ShovelRigidBody
     *         shovel is Terrain.Shovel:
     *             body: shovel_body
     *             top_edge: Math.Line.from_points(shovel_body.top_left, shovel_body.top_right)
     *             cutting_edge: Math.Line.from_points(shovel_body.bottom_left, shovel_body.bottom_right)
     *
     *     */
    class OPENPLX_Terrain_BUNDLE_EXPORT Shovel : public openplx::Core::Object, public openplx::Physics::Signals::MassOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            std::shared_ptr<openplx::Math::Line> m_top_edge;
            std::shared_ptr<openplx::Math::Line> m_cutting_edge;
            bool m_enabled;
            std::shared_ptr<openplx::Math::Vec3> m_tooth_direction;
            int64_t m_number_teeth;
            double m_tooth_min_radius;
            double m_tooth_max_radius;
            double m_tooth_length;
            std::shared_ptr<openplx::Physics::Signals::MassOutput> m_total_soil_mass_output;
            std::shared_ptr<openplx::Physics::Signals::MassOutput> m_inner_soil_mass_output;

        public:
            Shovel();
            virtual ~Shovel();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            std::shared_ptr<openplx::Math::Line> top_edge() const;
            std::shared_ptr<openplx::Math::Line> cutting_edge() const;
            bool enabled() const;
            std::shared_ptr<openplx::Math::Vec3> tooth_direction() const;
            int64_t number_teeth() const;
            double tooth_min_radius() const;
            double tooth_max_radius() const;
            double tooth_length() const;
            std::shared_ptr<openplx::Physics::Signals::MassOutput> total_soil_mass_output() const;
            std::shared_ptr<openplx::Physics::Signals::MassOutput> inner_soil_mass_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
