#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/SensorLogic.h>
#include <openplx/Sensors/Traits/MateConnectorAttachment.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LidarLogic */
namespace openplx::Sensors {
    /**
     *     Logical sensor functioning of a lidar sensor.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT LidarLogic : public openplx::Sensors::SensorLogic, public openplx::Sensors::Traits::MateConnectorAttachment {
        protected:
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_mate_connector_attachment;

        public:
            LidarLogic();
            virtual ~LidarLogic();
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> mate_connector_attachment() const override;
            std::vector<std::shared_ptr<openplx::Sensors::LidarSensingDistortion>> sensing_distortions() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
