#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/LidarSensingDistortion.h>
#include <openplx/Math/Random/GaussianDistribution.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LidarDetectionDistanceGaussianNoise */
namespace openplx::Sensors {
    /**
     *     A Gaussian noise error in the detection distance of lidar points.
     *
     *     The noise applied to a distance depends on the base standard deviation and the specified
     *     standard deviation slope, denoting standard deviation change per meter.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT LidarDetectionDistanceGaussianNoise : public openplx::Sensors::LidarSensingDistortion {
        protected:
            std::shared_ptr<openplx::Math::Random::GaussianDistribution> m_gaussian_distribution;
            double m_standard_deviation_slope;

        public:
            LidarDetectionDistanceGaussianNoise();
            virtual ~LidarDetectionDistanceGaussianNoise();
            std::shared_ptr<openplx::Math::Random::GaussianDistribution> gaussian_distribution() const;
            double standard_deviation_slope() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
