#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>
#include <openplx/Sensors/PulsedLidarLogic.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model VLP16 */
namespace openplx::Sensors::Library::LIDARs::Velodyne {
    /**
     *         Velodyne VLP-16 LIDAR.
     *         Data sheet: https://www.hypertech.co.il/wp-content/uploads/2015/12/63-9229_Rev-F_Puck__Spec_Sheet_Web.pdf
     *         User manual: https://docs.clearpathrobotics.com/assets/files/clearpath_robotics_029029-TDS2-00b7913d65b51a841cb5dc6c2b711487.pdf
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT VLP16 : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_connector;
            std::shared_ptr<openplx::Sensors::PulsedLidarLogic> m_logic;

        public:
            VLP16();
            virtual ~VLP16();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> connector() const;
            std::shared_ptr<openplx::Sensors::PulsedLidarLogic> logic() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
