#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Connector.h>
#include <openplx/Physics3D/Signals/MateConnector/MCLinearVelocity3DOutputTrait.h>
#include <openplx/Physics3D/Signals/MateConnector/MCAngularVelocity3DOutputTrait.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model MateConnector */
namespace openplx::Physics3D::Interactions {
    /**
     * The MateConnector has a implicit frame defined from two orthogonal vectors local to the owning model.
     * The two vectors are named main_axis and normal and they must span a plane in 2D. If the normal is not specified
     * OpenPLX computes an orthogonal normalized vector to the main_axis.
     * The purpose of the main_axis is to act as the direction of an interaction that is used as e.g. the rotational dof of a hinge,
     * translational dof of a prismatic, or the normal axis of a planar constraint. The purpose of the normal axis is to define the two
     * orthogonal directions (binormal = main_axis x normal).
     *
     * If the model require parametrisation in any direction orthogonal to the main_axis,
     * or if you model something like the hands on the clock, you like for example the default zero position
     * to point to twelve aclock, you make sure the normal axis of the MateConnector on the clock point towards twelve.
     *
     * Physics3D has the concept of a reference mate connector at the origin.
     *
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT MateConnector : public openplx::Physics::Interactions::Connector, public openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait, public openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_position;
            std::shared_ptr<openplx::Math::Vec3> m_main_axis;
            std::shared_ptr<openplx::Math::Vec3> m_normal;

        public:
            MateConnector();
            virtual ~MateConnector();
            std::shared_ptr<openplx::Math::Vec3> position() const;
            std::shared_ptr<openplx::Math::Vec3> main_axis() const;
            std::shared_ptr<openplx::Math::Vec3> normal() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
