#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SignalInterface */
namespace openplx::Physics::Signals {
    /**
     * Input and output reference attributes will be picked up by the signalling interface
     * allowing the user to model specific signalling interfaces by grouping inputs and outputs
     * and giving them shorter names.
     *
     * Setting enable to true enables all outputs in the interface. Keeping it as false does not
     * disable the outputs.
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT SignalInterface : public openplx::Core::Object {
        protected:
            bool m_enable;

        public:
            SignalInterface();
            virtual ~SignalInterface();
            void on_init(const openplx::RuntimeContext& context) override;
            bool enable() const;
            void enableAllOutputs();
            std::unordered_map<std::string, std::shared_ptr<openplx::Physics::Signals::Input>> getInputs() const;
            std::unordered_map<std::string, std::shared_ptr<openplx::Physics::Signals::Output>> getOutputs() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
