#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultDryFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     Used to specify the default dry friction model for the runtime environment.
     *     Dry friction is the resistance to relative motion between two solid surfaces in contact
     *     when there is no lubrication or fluid present between them.
     *     It occurs due to intermolecular interactions at the contact points between
     *     the surfaces and is proportional to the normal force pressing the surfaces together.
     *     Dry friction is characterized by the existence of a friction coefficient
     *     that determines the magnitude of the frictional force opposing motion
     *     or impending motion between the surfaces.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT DefaultDryFriction : public openplx::Physics::Interactions::Dissipation::DefaultFriction {
        protected:
            double m_coefficient;

        public:
            DefaultDryFriction();
            virtual ~DefaultDryFriction();
            double coefficient() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
