#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultClearance */
namespace openplx::Physics::Interactions::Clearance {
    /**
     *     For mates like hinges, prismatics etc., or between contacting surfaces,
     *     clearance refers to the loose or extra space that exists which allows for some amount of movement.
     *     Often, this term is used in mechanical or manufacturing contexts. 
     *     For instance, a door hinge might have a clearance that allows it to move or swing more freely.
     *     Alternatively, if two objects are meant to fit snugly together but don't, the extra space between them would be considered a clearance.
     *
     *     In a perfect world with perfect manufacturing, there would be no clearance as objects designed to interact would fit together perfectly.
     *     However, in reality, some infinitesimal clearance is often allowed for to ensure smooth operation or for tolerances in manufacturing.
     *     Too large clearances, however, can lead to instability or failure of a system.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT DefaultClearance : public openplx::Core::Object {
        protected:

        public:
            DefaultClearance();
            virtual ~DefaultClearance();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
