#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Material */
namespace openplx::Physics::Geometries {
    /**
     *     Base type for Material
     *     Defines an isotropic material of a rigid volume.
     *     To define how the material interacts with other materials
     *     a SurfaceContact.Model must be defined referencing two materials.
     *
     *     unique name - A Material is intended to be globally unique to support interactions between objects.
     *         In order to be able to merge identical materials when loading multiple .openplx files
     *         that uses the same materials it is strongly recommended to give each material
     *         a unique name in the unique_name attribute. If left empty it will default to the
     *         <bundle name>.<namespace>.<model name>.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT Material : public openplx::Core::Object {
        protected:
            std::string m_unique_name;
            double m_density;

        public:
            Material();
            virtual ~Material();
            std::string unique_name() const;
            double density() const;
            void on_init(const openplx::RuntimeContext& context) override;
            bool is_default_material() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
