
#pragma once

#include <iterator>
#include <memory>
#include <openplx/Token.h>
#include <openplx/ErrorReporter.h>
#include <openplx/Document.h>

namespace openplx
{
    class Parser
    {
        public:
            static DocPtr parseDocument(
                const char* input,
                size_t input_size,
                std::string source_id,
                ErrorReporter& error_reporter);

            static DocPtr parseDocument(
                    const std::string& source,
                    std::string source_id,
                    ErrorReporter& error_reporter);

            static DocPtr parseDocumentFromTokens(
                    const std::vector<Token>& tokens,
                    std::string source_id,
                    ErrorReporter& error_reporter);

            static std::vector<DocPtr> parseDocuments(
                const char* input,
                size_t input_size,
                std::string source_id,
                ErrorReporter& error_reporter);

            static std::vector<DocPtr> parseDocuments(
                const std::string& source,
                std::string source_id,
                ErrorReporter& error_reporter);

            static std::vector<DocPtr> parseDocumentsFromTokens(
                const std::vector<Token>& tokens,
                std::string source_id,
                ErrorReporter& error_reporter);
    };
}
