
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>

namespace openplx
{
    class OperatorOverload : public Node, public std::enable_shared_from_this<OperatorOverload>
    {
        public:
            /* Factories */
            static OpOverloadPtr create(
                const Token& op_token,
                const std::vector<ParamPtr>& parameters,
                const std::vector<Token>& return_type_segments);

            /* Overrides */
            OpOverloadPtr asOperatorOverload() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Operator */
            Token getOpToken() const;

            /* Parameters */
            const std::vector<ParamPtr>& getParameters() const;
            void appendToParameters(ParamPtr parameter);

            /* Return type */
            const std::vector<Token>& getReturnTypeSegments() const;
            TypePtr getReturnType() const;
            void setReturnType(TypePtr return_type);

            /* Owning document */
            DocPtr getOwningDocument() const;
            void setOwningDocument(DocPtr owning_document);

            /* Key */
            std::string toKey() const;

        private:
            OperatorOverload();
            Token m_op_token;
            std::vector<ParamPtr> m_parameters;
            std::vector<Token> m_return_type_segments;
            TypePtr m_return_type;
            DocPtr m_owning_document;
    };
}
