#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CatC27 */
namespace openplx::DriveTrain::Engines {
    /**
     *         Diesel Engine in CAT D10 Dozer. https://s7d2.scene7.com/is/content/Caterpillar/CM20221025-d8691-7d308
     *         Reference: https://emc.cat.com/pubdirect.ashx?media_string_id=SS-8230179-18397086-037.pdf
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT CatC27 : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            CatC27();
            virtual ~CatC27();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
