/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/RaytraceHandles.h>

#include <agx/Referenced.h>

namespace agxSensor
{
  DOXYGEN_START_INTERNAL_BLOCK()

  struct RtShapeInstanceHandle;

  AGX_DECLARE_POINTER_TYPES(RtInstanceData);

  class AGXSENSOR_EXPORT RtInstanceData : public agx::Referenced
  {
    public:
      RtInstanceData() = default;
      RtInstanceData( RtMaterialInstance materialInstance,
                      RtEntityId entityId = NullRtEntityId );

      void setInstanceHandle( RtShapeInstanceHandle* instanceHandle );
      RtShapeInstanceHandle* getInstanceHandle() const;

      void setMaterial( RtMaterialInstance materialInstance );
      RtMaterialInstance getMaterial() const;

      RtEntityId getOrCreateEntityId();

      void setEntityId( RtEntityId id );
      RtEntityId getEntityId() const;
      void destroyEntityId();

    protected:
      virtual ~RtInstanceData();

    private:
      RtShapeInstanceHandle* m_instanceHandle = nullptr;
      RtMaterialInstance m_materialInstance{};
      RtEntityId m_entityId = NullRtEntityId;
  };

  DOXYGEN_END_INTERNAL_BLOCK()
}
