/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/MonoaxialSignalSystemNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( MonoaxialSignalScaling );

  /**
  Applies a constant scaling to the monoaxial signal.
  */
  class AGXSENSOR_EXPORT MonoaxialSignalScaling : public IMonoaxialSignalSystemNode
  {
    public:
      /**
      Construct this signal scaling node using the given \p scaling.
      \param scaling - Sensor signal scaling (unitless)
      */
      MonoaxialSignalScaling( agx::Real scaling );

      /**
      Set the sensor signal scaling applied by this node.
      \param scaling - Sensor signal scaling (unitless)
      */
      void setScaling( agx::Real scaling );

      /**
      \return sensor signal scaling (unitless)
      */
      agx::Real getScaling() const;

      /**
      \return new, unique, monoaxial signal system node (proxy) of this implementation
      */
      virtual MonoaxialSignalSystemNodeRef createMonoaxialNodeProxy() override;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      MonoaxialSignalScaling();

      virtual void result( SystemNodeProxy& proxy, const CallbackData& data ) override;
      virtual void cleanup( SystemNodeProxy& proxy ) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::MonoaxialSignalScaling );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::Real m_scaling;
  };
}
