/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/EulerAngles.h>
#include <agx/Quat.h>
#include <agx/Vec3.h>
#include <agxQt/export.h>
#include <agxQt/QtOSGUtils.h>

#include <agx/PushDisableWarnings.h> // Disabling warnings. Include agx/PopDisableWarnings.h below!
#include <QWidget>
#include <agxQt/ui_MeasurementAxesWidget.h>
#include <agx/PopDisableWarnings.h> // End of disabled warnings.


namespace agxQt
{
  /**
  * MeasurementAxesWidget for controlling the measurement axes in qtViewer
  */
  class AGXQT_EXPORT MeasurementAxesWidget : public QWidget
  {
    Q_OBJECT

  public:
    explicit MeasurementAxesWidget(QWidget *parent = 0);

    virtual ~MeasurementAxesWidget();

    void connectSignals();

    void setController( agxQt::MeasurementAxesController* controller );

  private:
    void setEnableGUI(bool enable);

  public:
    signals:
      void signalMeasurementAxesUpdated();

  public slots:
    void slotUpdateGUI();

  private slots:
    void slotCenterEditFinished();
    void slotRotationEditFinished();
    void slotSizeEditFinished();
    void slotLengthEditFinished();
    void slotTicksLengthEditFinished();
    void slotTicksTextSizeEditFinished();
    void slotNumTicksChanged(int);
    void slotTickTextStrideChanged( int );
    void slotEnableChecked();
    void slotShowIndividualAxisChecked();
    void slotEnableTicksChecked();
    void slotEnableTicksTextChecked();
    void slotEnableGridChecked();
    void slotUpdateGUIFromMeasurementAxes();
    void slotTickColorComboBoxCurrentIndexChanged( int index );
    void slotAxesColorComboBoxCurrentIndexChanged( int index );
    void slotEnableAxesSingleColorChecked();

    //////////////////////////////////////////////////////////////////////////
    // Variables
    //////////////////////////////////////////////////////////////////////////
  private:
    Ui::MeasurementAxesWidget*                     m_ui;
    agxQt::MeasurementAxesControllerObserver       m_controller;
    agx::HashTable < agx::Name, agxRender::Color > m_colorMap;
  };
}
