/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <optional>
#include <set>
#include <string>
#include <unordered_map>
#include <agxCollide/Geometry.h>
#include <agxSDK/Assembly.h>
#include <agxOpenPLX/export.h>

namespace agxopenplx
{

  /**
   * Cached AGX instances that are loaded by the AGX plugin. The cached instances
   * can then be used by the OpenPlxToAgxMapper to skip instantiating large instances
   * like meshes. Right now we just cache shapes.
   **/
  class AGXOPENPLX_EXPORT AgxCache
  {
    public:
      AgxCache() {}

      std::optional<agxCollide::ShapeRef> readCollisionShape(const std::string& uuid);
      std::optional<std::pair<agxCollide::ShapeRef, agx::AffineMatrix4x4>> readCollisionShapeAndTransform(
        const std::string& uuid);

      void writeCollisionShape(const agxCollide::ShapeRef& shape);
      void cacheShapes(const agxSDK::AssemblyRef& assembly);
      void flagAsConsumed(const std::string& uuid);
      bool isConsumed(const std::string& uuid) const;

    private:
      std::unordered_map<std::string, std::pair<agxCollide::ShapeRef, agx::AffineMatrix4x4>> m_collision_shape_cache;
      std::set<std::string> m_consumed;
  };
}
