/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/NlmcpCallback.h>

namespace agx
{
  class FrictionController;

  /**
  Solver callback class for elementary FrictionController.
  */
  class FrictionControllerNlCallback : public ConstraintNlmcpCallback
  {
    public:
      struct ContextData
      {
        ContextData()
        {
          rowOffset = InvalidIndex;
          ecIndices[ 0 ] = ecIndices[ 1 ] = InvalidIndex;
        }

        UInt rowOffset;
        Vec2u ecIndices;
        bool useSecondaryConstraint = false;
      };


    public:
      static ContextData findContextData( const FrictionController* frictionController, const ConstraintImplementation* context );
      static Real calculateNormalForce( const ConstraintImplementation* context, ContextData contextData );

      static RangeReal calculateBound( Real normalImpact,
                                       Real frictionCoefficient,
                                       // Minimum (close to zero) bound - default [0, 0], i.e.,
                                       // the bound may be zero if the normal force is zero. This
                                       // is the FrictionController::setMinimumStaticFrictionForceRange
                                       // but scaled with the time step size.
                                       RangeReal minBound = RangeReal{ 0.0 } );

    public:
      /**
      Default constructor.
      */
      FrictionControllerNlCallback( const FrictionController* frictionController );

      Real calculateNormalForce() const;
      Real calculateNormalForce( const ConstraintImplementation* context ) const;

      virtual Bool initialize( const NlmcpCallback::Args& args ) override;

      virtual Real calculateResidual( const NlmcpCallback::Args& args ) const override;

      virtual void update( const NlmcpCallback::Args& args ) const override;

      virtual void postIterativeSolve( const NlmcpCallback::Args& /*args*/ ) const override;

    protected:
      virtual ~FrictionControllerNlCallback();

      virtual void onSetContext( const NlmcpCallbackSolverData& ) override;

    protected:
      Real calculateNormalImpact( const RealValarray& z ) const;

    private:
      const FrictionController* m_frictionController;
      ContextData m_contextData;
  };
}
