// Copyright Epic Games, Inc. All Rights Reserved.
/*===========================================================================
	Generated code exported from UnrealHeaderTool.
	DO NOT modify this manually! Edit the corresponding .h files instead!
===========================================================================*/

#include "UObject/GeneratedCppIncludes.h"
#include "Wire/AGX_WireWinch.h"
#include "AGX_RealInterval.h"
#include "AGX_RigidBodyReference.h"

PRAGMA_DISABLE_DEPRECATION_WARNINGS
static_assert(!UE_WITH_CONSTINIT_UOBJECT, "This generated code can only be compiled with !UE_WITH_CONSTINIT_OBJECT");
void EmptyLinkFunctionForGeneratedCodeAGX_WireWinch() {}

// ********** Begin Cross Module References ********************************************************
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_RigidBodyComponent_NoRegister();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_WireWinch_FL();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_WireWinch_FL_NoRegister();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_RigidBodyReference();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinch();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinchRef();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinchSettings();
AGXUNREALBARRIER_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_RealInterval();
COREUOBJECT_API UScriptStruct* Z_Construct_UScriptStruct_FRotator();
COREUOBJECT_API UScriptStruct* Z_Construct_UScriptStruct_FVector();
ENGINE_API UClass* Z_Construct_UClass_UBlueprintFunctionLibrary();
UPackage* Z_Construct_UPackage__Script_AGXUnreal();
// ********** End Cross Module References **********************************************************

// ********** Begin ScriptStruct FAGX_WireWinchSettings ********************************************
struct Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics
{
	static inline consteval int32 GetStructSize() { return sizeof(FAGX_WireWinchSettings); }
	static inline consteval int16 GetStructAlignment() { return alignof(FAGX_WireWinchSettings); }
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Struct_MetaDataParams[] = {
		{ "Comment", "/**\n * Holds all the properties that make up the settings of a Wire Winch. The Barrier object and all\n * the functions are in FAGX_WireWinch, which inherits from this struct. We need this extra layer\n * because Unreal Engine require that all structs be copy assignable but our Barrier objects are\n * not copyable. By moving all the members that should be copied by the copy assignment operator\n * to a base class we make it safer to implement the operator.\n *\n * Access to these properties are provided by FAGX_WireWinch_BP and UAGX_WireWinch_FL because of\n * limitations in how the Blueprint VM handles structs.\n */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "Holds all the properties that make up the settings of a Wire Winch. The Barrier object and all\nthe functions are in FAGX_WireWinch, which inherits from this struct. We need this extra layer\nbecause Unreal Engine require that all structs be copy assignable but our Barrier objects are\nnot copyable. By moving all the members that should be copied by the copy assignment operator\nto a base class we make it safer to implement the operator.\n\nAccess to these properties are provided by FAGX_WireWinch_BP and UAGX_WireWinch_FL because of\nlimitations in how the Blueprint VM handles structs." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Location_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * The location of the winch relative to some parent object [cm].\n\x09 *\n\x09 * For a Wire Component owned winch without a body attachment the parent is the Wire Component.\n\x09 * For a Wire Component owned winch with a body attachment the parent is the body.\n\x09 * For a Winch Component owned winch the parent is always the Winch Component.\n\x09 *\n\x09 * Only used during setup, cannot be changed after Begin Play.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "The location of the winch relative to some parent object [cm].\n\nFor a Wire Component owned winch without a body attachment the parent is the Wire Component.\nFor a Wire Component owned winch with a body attachment the parent is the body.\nFor a Winch Component owned winch the parent is always the Winch Component.\n\nOnly used during setup, cannot be changed after Begin Play." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Rotation_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * The orientation of the winch relative to some parent object [deg].\n\x09 *\n\x09 * For a Wire Component owned winch without a body attachment the parent is the Wire Component.\n\x09 * For a Wire Component owned winch with a body attachment the parent is the body.\n\x09 * For a Winch Component owned winch the parent is always the Winch Component.\n\x09 *\n\x09 * With a zero rotation the winch will point the wire along the X axis.\n\x09 *\n\x09 * Only used during setup, cannot be changed once Begin Play has been called.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "The orientation of the winch relative to some parent object [deg].\n\nFor a Wire Component owned winch without a body attachment the parent is the Wire Component.\nFor a Wire Component owned winch with a body attachment the parent is the body.\nFor a Winch Component owned winch the parent is always the Winch Component.\n\nWith a zero rotation the winch will point the wire along the X axis.\n\nOnly used during setup, cannot be changed once Begin Play has been called." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_BodyAttachment_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "// I would perhaps like to make this a BlueprintReadWrite property, but FAGX_RigidBodyReference\n// is currently not a BlueprintType. Should it be? We deliberately did not make it a Blueprint\n// type previously because the type is a bit \"special\" and we didn't know what the implications\n// of making it a BlueprintType would be. Do we know more now? Should it be made a\n// BlueprintType? What operations on it should we support in Blueprint Visual Scripts?\n" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "I would perhaps like to make this a BlueprintReadWrite property, but FAGX_RigidBodyReference\nis currently not a BlueprintType. Should it be? We deliberately did not make it a Blueprint\ntype previously because the type is a bit \"special\" and we didn't know what the implications\nof making it a BlueprintType would be. Do we know more now? Should it be made a\nBlueprintType? What operations on it should we support in Blueprint Visual Scripts?" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_PulledInLength_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * The amount of wire that exists inside the winch [cm].\n\x09 *\n\x09 * If auto feed is enabled then this value is decreased by the length of the wire route on\n\x09 * initialization.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "The amount of wire that exists inside the winch [cm].\n\nIf auto feed is enabled then this value is decreased by the length of the wire route on\ninitialization." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_bAutoFeed_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * This mode can be used to facilitate routing. E.g., put all wire in this winch (start of\n\x09 * route), set mode to auto feed, and route. The wire will automatically decrease in this winch\n\x09 * to fulfill the rout without initial tension.\n\x09 *\n\x09 * Only used during setup, cannot be changed once Begin Play has been called.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "This mode can be used to facilitate routing. E.g., put all wire in this winch (start of\nroute), set mode to auto feed, and route. The wire will automatically decrease in this winch\nto fulfill the rout without initial tension.\n\nOnly used during setup, cannot be changed once Begin Play has been called." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_bMotorEnabled_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * Set to true to enable the motor paying out or hauling in wire. The direction is controlled\n\x09 * by the sign of Target Speed.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "Set to true to enable the motor paying out or hauling in wire. The direction is controlled\nby the sign of Target Speed." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_TargetSpeed_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * The speed at which this winch is trying to haul in or pay out wire [cm/s].\n\x09 *\n\x09 * It may be unable to reach the target speed because of force range limitations and resistance\n\x09 * from the brake.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "The speed at which this winch is trying to haul in or pay out wire [cm/s].\n\nIt may be unable to reach the target speed because of force range limitations and resistance\nfrom the brake." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_MotorForceRange_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * The allowed force range when paying out and hauling in wire [N].\n\x09 *\n\x09 * The lower end of the range is used when hauling in and the upper range when paying out. The\n\x09 * lower end must be less than zero and the upper range must be greater than zero.\n\x09 *\n\x09 * The actual force range on the Native is set to this value while the motor is enabled. When\n\x09 * the motor is disabled the Native's motor force range is instead set to zero.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "The allowed force range when paying out and hauling in wire [N].\n\nThe lower end of the range is used when hauling in and the upper range when paying out. The\nlower end must be less than zero and the upper range must be greater than zero.\n\nThe actual force range on the Native is set to this value while the motor is enabled. When\nthe motor is disabled the Native's motor force range is instead set to zero." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_bBrakeEnabled_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * Set to true to enable the brake.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "Set to true to enable the brake." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_BrakeForceRange_MetaData[] = {
		{ "Category", "Wire Winch" },
		{ "Comment", "/**\n\x09 * Set the desired brake force range [N].\n\x09 *\n\x09 * The lower end of the range is the force with which this winch brake can hold the wire from\n\x09 * hauling in and the upper end of the range is the force with which this winch brake can hold\n\x09 * the wire from paying out.\n\x09 *\n\x09 * It's important that the lower value is less than zero and the upper larger than zero.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "Set the desired brake force range [N].\n\nThe lower end of the range is the force with which this winch brake can hold the wire from\nhauling in and the upper end of the range is the force with which this winch brake can hold\nthe wire from paying out.\n\nIt's important that the lower value is less than zero and the upper larger than zero." },
	};
#endif // WITH_METADATA

// ********** Begin ScriptStruct FAGX_WireWinchSettings constinit property declarations ************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Location;
	static const UECodeGen_Private::FStructPropertyParams NewProp_Rotation;
	static const UECodeGen_Private::FStructPropertyParams NewProp_BodyAttachment;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_PulledInLength;
	static void NewProp_bAutoFeed_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bAutoFeed;
	static void NewProp_bMotorEnabled_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bMotorEnabled;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_TargetSpeed;
	static const UECodeGen_Private::FStructPropertyParams NewProp_MotorForceRange;
	static void NewProp_bBrakeEnabled_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bBrakeEnabled;
	static const UECodeGen_Private::FStructPropertyParams NewProp_BrakeForceRange;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End ScriptStruct FAGX_WireWinchSettings constinit property declarations **************
	static void* NewStructOps()
	{
		return (UScriptStruct::ICppStructOps*)new UScriptStruct::TCppStructOps<FAGX_WireWinchSettings>();
	}
	static const UECodeGen_Private::FStructParams StructParams;
}; // struct Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics
static FStructRegistrationInfo Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings;
class UScriptStruct* FAGX_WireWinchSettings::StaticStruct()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.OuterSingleton)
	{
		Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.OuterSingleton = GetStaticStruct(Z_Construct_UScriptStruct_FAGX_WireWinchSettings, (UObject*)Z_Construct_UPackage__Script_AGXUnreal(), TEXT("AGX_WireWinchSettings"));
	}
	return Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.OuterSingleton;
	}

// ********** Begin ScriptStruct FAGX_WireWinchSettings Property Definitions ***********************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_Location = { "Location", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, Location), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Location_MetaData), NewProp_Location_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_Rotation = { "Rotation", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, Rotation), Z_Construct_UScriptStruct_FRotator, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Rotation_MetaData), NewProp_Rotation_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_BodyAttachment = { "BodyAttachment", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, BodyAttachment), Z_Construct_UScriptStruct_FAGX_RigidBodyReference, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_BodyAttachment_MetaData), NewProp_BodyAttachment_MetaData) }; // 2713262358
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_PulledInLength = { "PulledInLength", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, PulledInLength), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_PulledInLength_MetaData), NewProp_PulledInLength_MetaData) };
void Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bAutoFeed_SetBit(void* Obj)
{
	((FAGX_WireWinchSettings*)Obj)->bAutoFeed = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bAutoFeed = { "bAutoFeed", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(FAGX_WireWinchSettings), &Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bAutoFeed_SetBit, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_bAutoFeed_MetaData), NewProp_bAutoFeed_MetaData) };
void Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bMotorEnabled_SetBit(void* Obj)
{
	((FAGX_WireWinchSettings*)Obj)->bMotorEnabled = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bMotorEnabled = { "bMotorEnabled", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(FAGX_WireWinchSettings), &Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bMotorEnabled_SetBit, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_bMotorEnabled_MetaData), NewProp_bMotorEnabled_MetaData) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_TargetSpeed = { "TargetSpeed", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, TargetSpeed), METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_TargetSpeed_MetaData), NewProp_TargetSpeed_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_MotorForceRange = { "MotorForceRange", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, MotorForceRange), Z_Construct_UScriptStruct_FAGX_RealInterval, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_MotorForceRange_MetaData), NewProp_MotorForceRange_MetaData) }; // 3120101040
void Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bBrakeEnabled_SetBit(void* Obj)
{
	((FAGX_WireWinchSettings*)Obj)->bBrakeEnabled = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bBrakeEnabled = { "bBrakeEnabled", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(FAGX_WireWinchSettings), &Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bBrakeEnabled_SetBit, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_bBrakeEnabled_MetaData), NewProp_bBrakeEnabled_MetaData) };
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_BrakeForceRange = { "BrakeForceRange", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_WireWinchSettings, BrakeForceRange), Z_Construct_UScriptStruct_FAGX_RealInterval, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_BrakeForceRange_MetaData), NewProp_BrakeForceRange_MetaData) }; // 3120101040
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_Location,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_Rotation,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_BodyAttachment,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_PulledInLength,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bAutoFeed,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bMotorEnabled,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_TargetSpeed,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_MotorForceRange,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_bBrakeEnabled,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewProp_BrakeForceRange,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::PropPointers) < 2048);
// ********** End ScriptStruct FAGX_WireWinchSettings Property Definitions *************************
const UECodeGen_Private::FStructParams Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::StructParams = {
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
	nullptr,
	&NewStructOps,
	"AGX_WireWinchSettings",
	Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::PropPointers,
	UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::PropPointers),
	sizeof(FAGX_WireWinchSettings),
	alignof(FAGX_WireWinchSettings),
	RF_Public|RF_Transient|RF_MarkAsNative,
	EStructFlags(0x00000201),
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::Struct_MetaDataParams), Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::Struct_MetaDataParams)
};
UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinchSettings()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.InnerSingleton)
	{
		UECodeGen_Private::ConstructUScriptStruct(Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.InnerSingleton, Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::StructParams);
	}
	return CastChecked<UScriptStruct>(Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings.InnerSingleton);
}
// ********** End ScriptStruct FAGX_WireWinchSettings **********************************************

// ********** Begin ScriptStruct FAGX_WireWinch ****************************************************
struct Z_Construct_UScriptStruct_FAGX_WireWinch_Statics
{
	static inline consteval int32 GetStructSize() { return sizeof(FAGX_WireWinch); }
	static inline consteval int16 GetStructAlignment() { return alignof(FAGX_WireWinch); }
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Struct_MetaDataParams[] = {
		{ "BlueprintType", "true" },
		{ "Comment", "/**\n * A Wire Winch is a carrier for the data required to create a Wire Winch along with the Barrier\n * object that houses the native AGX Dynamics instance. It is a simple struct, not any kind of\n * UObject, which means that it can't do much of the work itself, it needs help from an owning\n * Component. Most of the logic and customization required is performed by the UObject owning the\n * Wire Winch.\n */" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "A Wire Winch is a carrier for the data required to create a Wire Winch along with the Barrier\nobject that houses the native AGX Dynamics instance. It is a simple struct, not any kind of\nUObject, which means that it can't do much of the work itself, it needs help from an owning\nComponent. Most of the logic and customization required is performed by the UObject owning the\nWire Winch." },
	};
#endif // WITH_METADATA

// ********** Begin ScriptStruct FAGX_WireWinch constinit property declarations ********************
// ********** End ScriptStruct FAGX_WireWinch constinit property declarations **********************
	static void* NewStructOps()
	{
		return (UScriptStruct::ICppStructOps*)new UScriptStruct::TCppStructOps<FAGX_WireWinch>();
	}
	static const UECodeGen_Private::FStructParams StructParams;
}; // struct Z_Construct_UScriptStruct_FAGX_WireWinch_Statics
static_assert(std::is_polymorphic<FAGX_WireWinch>() == std::is_polymorphic<FAGX_WireWinchSettings>(), "USTRUCT FAGX_WireWinch cannot be polymorphic unless super FAGX_WireWinchSettings is polymorphic");
static FStructRegistrationInfo Z_Registration_Info_UScriptStruct_FAGX_WireWinch;
class UScriptStruct* FAGX_WireWinch::StaticStruct()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinch.OuterSingleton)
	{
		Z_Registration_Info_UScriptStruct_FAGX_WireWinch.OuterSingleton = GetStaticStruct(Z_Construct_UScriptStruct_FAGX_WireWinch, (UObject*)Z_Construct_UPackage__Script_AGXUnreal(), TEXT("AGX_WireWinch"));
	}
	return Z_Registration_Info_UScriptStruct_FAGX_WireWinch.OuterSingleton;
	}
const UECodeGen_Private::FStructParams Z_Construct_UScriptStruct_FAGX_WireWinch_Statics::StructParams = {
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
	Z_Construct_UScriptStruct_FAGX_WireWinchSettings,
	&NewStructOps,
	"AGX_WireWinch",
	nullptr,
	0,
	sizeof(FAGX_WireWinch),
	alignof(FAGX_WireWinch),
	RF_Public|RF_Transient|RF_MarkAsNative,
	EStructFlags(0x00000201),
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_WireWinch_Statics::Struct_MetaDataParams), Z_Construct_UScriptStruct_FAGX_WireWinch_Statics::Struct_MetaDataParams)
};
UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinch()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinch.InnerSingleton)
	{
		UECodeGen_Private::ConstructUScriptStruct(Z_Registration_Info_UScriptStruct_FAGX_WireWinch.InnerSingleton, Z_Construct_UScriptStruct_FAGX_WireWinch_Statics::StructParams);
	}
	return CastChecked<UScriptStruct>(Z_Registration_Info_UScriptStruct_FAGX_WireWinch.InnerSingleton);
}
// ********** End ScriptStruct FAGX_WireWinch ******************************************************

// ********** Begin ScriptStruct FAGX_WireWinchRef *************************************************
struct Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics
{
	static inline consteval int32 GetStructSize() { return sizeof(FAGX_WireWinchRef); }
	static inline consteval int16 GetStructAlignment() { return alignof(FAGX_WireWinchRef); }
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Struct_MetaDataParams[] = {
		{ "BlueprintType", "true" },
		{ "Comment", "/*\n * We need this extra level of indirection between the Blueprint VM and FAGX_WireWinch because the\n * VM cannot handle references to structs returned from a function, such as GetBeginWinch, it always\n * copies the struct into the VM's memory before calling whatever function the next Blueprint node\n * along the wire is, typically one of the ones from UAGX_WireWinch_FL below. Also, Unreal Engine\n * does not support UFunctions on structs. Combined is a problem because FAGX_WireWinch contains a\n * non-copyable handle to the AGX Dynamics representation of the winch and thus the copy can't\n * manipulate the AGX Dynamics winch state.\n *\n * Consider the following Visual Script example:\n *\n *   Wire Blueprint variable -> Get Begin Winch -> Set Target Speed\n *\n * Get Begin Winch could return a reference to the actual FAGX_WireWinch, but the VM would create a\n * copy before calling Set Target Speed, which would therefore operate on an empty winch, one with\n * an invalid Barrier.\n *\n * We work around the limitation with this extra layer of indirection. By retuning a struct\n * containing a pointer to the FAGX_WireWinch the Blueprint VM can copy all it wants, and by\n * unpacking the pointer in the Blueprint Function Library functions below we are able to manipulate\n * the AGX Dynamics winch.\n *\n * An alternative approach would be to make the Barriers copyable, as opposed to just movable, but\n * testing has showed that changes made to the Blueprint VM's copy by the Blueprint Function Library\n * won't be copied back to the Wire Component's internal FAGX_WireWinch instance. This may be a bug\n * or something we're not doing right.\n */" },
		{ "DisplayName", "AGX Wire Winch Ref" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "* We need this extra level of indirection between the Blueprint VM and FAGX_WireWinch because the\n* VM cannot handle references to structs returned from a function, such as GetBeginWinch, it always\n* copies the struct into the VM's memory before calling whatever function the next Blueprint node\n* along the wire is, typically one of the ones from UAGX_WireWinch_FL below. Also, Unreal Engine\n* does not support UFunctions on structs. Combined is a problem because FAGX_WireWinch contains a\n* non-copyable handle to the AGX Dynamics representation of the winch and thus the copy can't\n* manipulate the AGX Dynamics winch state.\n*\n* Consider the following Visual Script example:\n*\n*   Wire Blueprint variable -> Get Begin Winch -> Set Target Speed\n*\n* Get Begin Winch could return a reference to the actual FAGX_WireWinch, but the VM would create a\n* copy before calling Set Target Speed, which would therefore operate on an empty winch, one with\n* an invalid Barrier.\n*\n* We work around the limitation with this extra layer of indirection. By retuning a struct\n* containing a pointer to the FAGX_WireWinch the Blueprint VM can copy all it wants, and by\n* unpacking the pointer in the Blueprint Function Library functions below we are able to manipulate\n* the AGX Dynamics winch.\n*\n* An alternative approach would be to make the Barriers copyable, as opposed to just movable, but\n* testing has showed that changes made to the Blueprint VM's copy by the Blueprint Function Library\n* won't be copied back to the Wire Component's internal FAGX_WireWinch instance. This may be a bug\n* or something we're not doing right." },
	};
#endif // WITH_METADATA

// ********** Begin ScriptStruct FAGX_WireWinchRef constinit property declarations *****************
// ********** End ScriptStruct FAGX_WireWinchRef constinit property declarations *******************
	static void* NewStructOps()
	{
		return (UScriptStruct::ICppStructOps*)new UScriptStruct::TCppStructOps<FAGX_WireWinchRef>();
	}
	static const UECodeGen_Private::FStructParams StructParams;
}; // struct Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics
static FStructRegistrationInfo Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef;
class UScriptStruct* FAGX_WireWinchRef::StaticStruct()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.OuterSingleton)
	{
		Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.OuterSingleton = GetStaticStruct(Z_Construct_UScriptStruct_FAGX_WireWinchRef, (UObject*)Z_Construct_UPackage__Script_AGXUnreal(), TEXT("AGX_WireWinchRef"));
	}
	return Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.OuterSingleton;
	}
const UECodeGen_Private::FStructParams Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics::StructParams = {
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
	nullptr,
	&NewStructOps,
	"AGX_WireWinchRef",
	nullptr,
	0,
	sizeof(FAGX_WireWinchRef),
	alignof(FAGX_WireWinchRef),
	RF_Public|RF_Transient|RF_MarkAsNative,
	EStructFlags(0x00000201),
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics::Struct_MetaDataParams), Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics::Struct_MetaDataParams)
};
UScriptStruct* Z_Construct_UScriptStruct_FAGX_WireWinchRef()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.InnerSingleton)
	{
		UECodeGen_Private::ConstructUScriptStruct(Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.InnerSingleton, Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics::StructParams);
	}
	return CastChecked<UScriptStruct>(Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef.InnerSingleton);
}
// ********** End ScriptStruct FAGX_WireWinchRef ***************************************************

// ********** Begin Class UAGX_WireWinch_FL Function GetBodyAttachment *****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics
{
	struct AGX_WireWinch_FL_eventGetBodyAttachment_Parms
	{
		FAGX_WireWinchRef Winch;
		UAGX_RigidBodyComponent* ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_ReturnValue_MetaData[] = {
		{ "EditInline", "true" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetBodyAttachment constinit property declarations *********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FObjectPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetBodyAttachment constinit property declarations ***********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetBodyAttachment Property Definitions ********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBodyAttachment_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FObjectPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000080588, UECodeGen_Private::EPropertyGenFlags::Object, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBodyAttachment_Parms, ReturnValue), Z_Construct_UClass_UAGX_RigidBodyComponent_NoRegister, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_ReturnValue_MetaData), NewProp_ReturnValue_MetaData) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::PropPointers) < 2048);
// ********** End Function GetBodyAttachment Property Definitions **********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetBodyAttachment", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::AGX_WireWinch_FL_eventGetBodyAttachment_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::AGX_WireWinch_FL_eventGetBodyAttachment_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetBodyAttachment)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(UAGX_RigidBodyComponent**)Z_Param__Result=UAGX_WireWinch_FL::GetBodyAttachment(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetBodyAttachment *******************************

// ********** Begin Class UAGX_WireWinch_FL Function GetBrakeForceRangeMax *************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics
{
	struct AGX_WireWinch_FL_eventGetBrakeForceRangeMax_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetBrakeForceRangeMax constinit property declarations *****************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetBrakeForceRangeMax constinit property declarations *******************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetBrakeForceRangeMax Property Definitions ****************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBrakeForceRangeMax_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBrakeForceRangeMax_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::PropPointers) < 2048);
// ********** End Function GetBrakeForceRangeMax Property Definitions ******************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetBrakeForceRangeMax", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::AGX_WireWinch_FL_eventGetBrakeForceRangeMax_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::AGX_WireWinch_FL_eventGetBrakeForceRangeMax_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetBrakeForceRangeMax)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetBrakeForceRangeMax(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetBrakeForceRangeMax ***************************

// ********** Begin Class UAGX_WireWinch_FL Function GetBrakeForceRangeMin *************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics
{
	struct AGX_WireWinch_FL_eventGetBrakeForceRangeMin_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetBrakeForceRangeMin constinit property declarations *****************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetBrakeForceRangeMin constinit property declarations *******************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetBrakeForceRangeMin Property Definitions ****************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBrakeForceRangeMin_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetBrakeForceRangeMin_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::PropPointers) < 2048);
// ********** End Function GetBrakeForceRangeMin Property Definitions ******************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetBrakeForceRangeMin", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::AGX_WireWinch_FL_eventGetBrakeForceRangeMin_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::AGX_WireWinch_FL_eventGetBrakeForceRangeMin_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetBrakeForceRangeMin)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetBrakeForceRangeMin(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetBrakeForceRangeMin ***************************

// ********** Begin Class UAGX_WireWinch_FL Function GetCurrentSpeed *******************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics
{
	struct AGX_WireWinch_FL_eventGetCurrentSpeed_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetCurrentSpeed constinit property declarations ***********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetCurrentSpeed constinit property declarations *************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetCurrentSpeed Property Definitions **********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetCurrentSpeed_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetCurrentSpeed_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::PropPointers) < 2048);
// ********** End Function GetCurrentSpeed Property Definitions ************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetCurrentSpeed", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::AGX_WireWinch_FL_eventGetCurrentSpeed_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::AGX_WireWinch_FL_eventGetCurrentSpeed_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetCurrentSpeed)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetCurrentSpeed(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetCurrentSpeed *********************************

// ********** Begin Class UAGX_WireWinch_FL Function GetLocation ***********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics
{
	struct AGX_WireWinch_FL_eventGetLocation_Parms
	{
		FAGX_WireWinchRef Winch;
		FVector ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetLocation constinit property declarations ***************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetLocation constinit property declarations *****************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetLocation Property Definitions **************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetLocation_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetLocation_Parms, ReturnValue), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::PropPointers) < 2048);
// ********** End Function GetLocation Property Definitions ****************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetLocation", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::AGX_WireWinch_FL_eventGetLocation_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::AGX_WireWinch_FL_eventGetLocation_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetLocation)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FVector*)Z_Param__Result=UAGX_WireWinch_FL::GetLocation(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetLocation *************************************

// ********** Begin Class UAGX_WireWinch_FL Function GetMotorForceRangeMax *************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics
{
	struct AGX_WireWinch_FL_eventGetMotorForceRangeMax_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetMotorForceRangeMax constinit property declarations *****************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetMotorForceRangeMax constinit property declarations *******************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetMotorForceRangeMax Property Definitions ****************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetMotorForceRangeMax_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetMotorForceRangeMax_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::PropPointers) < 2048);
// ********** End Function GetMotorForceRangeMax Property Definitions ******************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetMotorForceRangeMax", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::AGX_WireWinch_FL_eventGetMotorForceRangeMax_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::AGX_WireWinch_FL_eventGetMotorForceRangeMax_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetMotorForceRangeMax)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetMotorForceRangeMax(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetMotorForceRangeMax ***************************

// ********** Begin Class UAGX_WireWinch_FL Function GetMotorForceRangeMin *************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics
{
	struct AGX_WireWinch_FL_eventGetMotorForceRangeMin_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetMotorForceRangeMin constinit property declarations *****************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetMotorForceRangeMin constinit property declarations *******************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetMotorForceRangeMin Property Definitions ****************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetMotorForceRangeMin_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetMotorForceRangeMin_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::PropPointers) < 2048);
// ********** End Function GetMotorForceRangeMin Property Definitions ******************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetMotorForceRangeMin", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::AGX_WireWinch_FL_eventGetMotorForceRangeMin_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::AGX_WireWinch_FL_eventGetMotorForceRangeMin_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetMotorForceRangeMin)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetMotorForceRangeMin(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetMotorForceRangeMin ***************************

// ********** Begin Class UAGX_WireWinch_FL Function GetPulledInLength *****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics
{
	struct AGX_WireWinch_FL_eventGetPulledInLength_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetPulledInLength constinit property declarations *********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetPulledInLength constinit property declarations ***********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetPulledInLength Property Definitions ********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetPulledInLength_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetPulledInLength_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::PropPointers) < 2048);
// ********** End Function GetPulledInLength Property Definitions **********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetPulledInLength", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::AGX_WireWinch_FL_eventGetPulledInLength_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::AGX_WireWinch_FL_eventGetPulledInLength_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetPulledInLength)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetPulledInLength(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetPulledInLength *******************************

// ********** Begin Class UAGX_WireWinch_FL Function GetRotation ***********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics
{
	struct AGX_WireWinch_FL_eventGetRotation_Parms
	{
		FAGX_WireWinchRef Winch;
		FRotator ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetRotation constinit property declarations ***************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetRotation constinit property declarations *****************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetRotation Property Definitions **************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetRotation_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetRotation_Parms, ReturnValue), Z_Construct_UScriptStruct_FRotator, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::PropPointers) < 2048);
// ********** End Function GetRotation Property Definitions ****************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetRotation", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::AGX_WireWinch_FL_eventGetRotation_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::AGX_WireWinch_FL_eventGetRotation_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetRotation)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FRotator*)Z_Param__Result=UAGX_WireWinch_FL::GetRotation(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetRotation *************************************

// ********** Begin Class UAGX_WireWinch_FL Function GetTargetSpeed ********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics
{
	struct AGX_WireWinch_FL_eventGetTargetSpeed_Parms
	{
		FAGX_WireWinchRef Winch;
		float ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetTargetSpeed constinit property declarations ************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetTargetSpeed constinit property declarations **************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetTargetSpeed Property Definitions ***********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetTargetSpeed_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventGetTargetSpeed_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::PropPointers) < 2048);
// ********** End Function GetTargetSpeed Property Definitions *************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "GetTargetSpeed", 	Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::AGX_WireWinch_FL_eventGetTargetSpeed_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::AGX_WireWinch_FL_eventGetTargetSpeed_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execGetTargetSpeed)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(float*)Z_Param__Result=UAGX_WireWinch_FL::GetTargetSpeed(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function GetTargetSpeed **********************************

// ********** Begin Class UAGX_WireWinch_FL Function HasWire ***************************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics
{
	struct AGX_WireWinch_FL_eventHasWire_Parms
	{
		FAGX_WireWinchRef Winch;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function HasWire constinit property declarations *******************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function HasWire constinit property declarations *********************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function HasWire Property Definitions ******************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventHasWire_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
void Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventHasWire_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventHasWire_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::PropPointers) < 2048);
// ********** End Function HasWire Property Definitions ********************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "HasWire", 	Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::AGX_WireWinch_FL_eventHasWire_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::AGX_WireWinch_FL_eventHasWire_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execHasWire)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_WireWinch_FL::HasWire(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function HasWire *****************************************

// ********** Begin Class UAGX_WireWinch_FL Function IsBrakeEnabled ********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics
{
	struct AGX_WireWinch_FL_eventIsBrakeEnabled_Parms
	{
		FAGX_WireWinchRef Winch;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function IsBrakeEnabled constinit property declarations ************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function IsBrakeEnabled constinit property declarations **************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function IsBrakeEnabled Property Definitions ***********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventIsBrakeEnabled_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
void Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventIsBrakeEnabled_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventIsBrakeEnabled_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::PropPointers) < 2048);
// ********** End Function IsBrakeEnabled Property Definitions *************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "IsBrakeEnabled", 	Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::AGX_WireWinch_FL_eventIsBrakeEnabled_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::AGX_WireWinch_FL_eventIsBrakeEnabled_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execIsBrakeEnabled)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_WireWinch_FL::IsBrakeEnabled(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function IsBrakeEnabled **********************************

// ********** Begin Class UAGX_WireWinch_FL Function IsMotorEnabled ********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics
{
	struct AGX_WireWinch_FL_eventIsMotorEnabled_Parms
	{
		FAGX_WireWinchRef Winch;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function IsMotorEnabled constinit property declarations ************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function IsMotorEnabled constinit property declarations **************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function IsMotorEnabled Property Definitions ***********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventIsMotorEnabled_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
void Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventIsMotorEnabled_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventIsMotorEnabled_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::PropPointers) < 2048);
// ********** End Function IsMotorEnabled Property Definitions *************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "IsMotorEnabled", 	Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::AGX_WireWinch_FL_eventIsMotorEnabled_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::AGX_WireWinch_FL_eventIsMotorEnabled_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execIsMotorEnabled)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_WireWinch_FL::IsMotorEnabled(Z_Param_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function IsMotorEnabled **********************************

// ********** Begin Class UAGX_WireWinch_FL Function MakeRef ***************************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics
{
	struct AGX_WireWinch_FL_eventMakeRef_Parms
	{
		FAGX_WireWinch Winch;
		FAGX_WireWinchRef ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function MakeRef constinit property declarations *******************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FStructPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function MakeRef constinit property declarations *********************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function MakeRef Property Definitions ******************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventMakeRef_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinch, METADATA_PARAMS(0, nullptr) }; // 1182176698
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventMakeRef_Parms, ReturnValue), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::PropPointers) < 2048);
// ********** End Function MakeRef Property Definitions ********************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "MakeRef", 	Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::AGX_WireWinch_FL_eventMakeRef_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14422401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::AGX_WireWinch_FL_eventMakeRef_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execMakeRef)
{
	P_GET_STRUCT_REF(FAGX_WireWinch,Z_Param_Out_Winch);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(FAGX_WireWinchRef*)Z_Param__Result=UAGX_WireWinch_FL::MakeRef(Z_Param_Out_Winch);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function MakeRef *****************************************

// ********** Begin Class UAGX_WireWinch_FL Function SetBodyAttachment *****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics
{
	struct AGX_WireWinch_FL_eventSetBodyAttachment_Parms
	{
		FAGX_WireWinchRef Winch;
		UAGX_RigidBodyComponent* Body;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Body_MetaData[] = {
		{ "EditInline", "true" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetBodyAttachment constinit property declarations *********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FObjectPropertyParams NewProp_Body;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetBodyAttachment constinit property declarations ***********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetBodyAttachment Property Definitions ********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBodyAttachment_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FObjectPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_Body = { "Body", nullptr, (EPropertyFlags)0x0010000000080080, UECodeGen_Private::EPropertyGenFlags::Object, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBodyAttachment_Parms, Body), Z_Construct_UClass_UAGX_RigidBodyComponent_NoRegister, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Body_MetaData), NewProp_Body_MetaData) };
void Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventSetBodyAttachment_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventSetBodyAttachment_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_Body,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::PropPointers) < 2048);
// ********** End Function SetBodyAttachment Property Definitions **********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetBodyAttachment", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::AGX_WireWinch_FL_eventSetBodyAttachment_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::AGX_WireWinch_FL_eventSetBodyAttachment_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetBodyAttachment)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_OBJECT(UAGX_RigidBodyComponent,Z_Param_Body);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_WireWinch_FL::SetBodyAttachment(Z_Param_Winch,Z_Param_Body);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetBodyAttachment *******************************

// ********** Begin Class UAGX_WireWinch_FL Function SetBrakeEnabled *******************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics
{
	struct AGX_WireWinch_FL_eventSetBrakeEnabled_Parms
	{
		FAGX_WireWinchRef Winch;
		bool bInBrakeEnabled;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetBrakeEnabled constinit property declarations ***********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static void NewProp_bInBrakeEnabled_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bInBrakeEnabled;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetBrakeEnabled constinit property declarations *************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetBrakeEnabled Property Definitions **********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBrakeEnabled_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
void Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_bInBrakeEnabled_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventSetBrakeEnabled_Parms*)Obj)->bInBrakeEnabled = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_bInBrakeEnabled = { "bInBrakeEnabled", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventSetBrakeEnabled_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_bInBrakeEnabled_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::NewProp_bInBrakeEnabled,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::PropPointers) < 2048);
// ********** End Function SetBrakeEnabled Property Definitions ************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetBrakeEnabled", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::AGX_WireWinch_FL_eventSetBrakeEnabled_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::AGX_WireWinch_FL_eventSetBrakeEnabled_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetBrakeEnabled)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_UBOOL(Z_Param_bInBrakeEnabled);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetBrakeEnabled(Z_Param_Winch,Z_Param_bInBrakeEnabled);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetBrakeEnabled *********************************

// ********** Begin Class UAGX_WireWinch_FL Function SetBrakeForceRange ****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics
{
	struct AGX_WireWinch_FL_eventSetBrakeForceRange_Parms
	{
		FAGX_WireWinchRef Winch;
		float Min;
		float Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetBrakeForceRange constinit property declarations ********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Min;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetBrakeForceRange constinit property declarations **********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetBrakeForceRange Property Definitions *******************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBrakeForceRange_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBrakeForceRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetBrakeForceRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::PropPointers) < 2048);
// ********** End Function SetBrakeForceRange Property Definitions *********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetBrakeForceRange", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::AGX_WireWinch_FL_eventSetBrakeForceRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::AGX_WireWinch_FL_eventSetBrakeForceRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetBrakeForceRange)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Min);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetBrakeForceRange(Z_Param_Winch,Z_Param_Min,Z_Param_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetBrakeForceRange ******************************

// ********** Begin Class UAGX_WireWinch_FL Function SetLocation ***********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics
{
	struct AGX_WireWinch_FL_eventSetLocation_Parms
	{
		FAGX_WireWinchRef Winch;
		FVector InLocation;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetLocation constinit property declarations ***************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FStructPropertyParams NewProp_InLocation;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetLocation constinit property declarations *****************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetLocation Property Definitions **************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetLocation_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::NewProp_InLocation = { "InLocation", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetLocation_Parms, InLocation), Z_Construct_UScriptStruct_FVector, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::NewProp_InLocation,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::PropPointers) < 2048);
// ********** End Function SetLocation Property Definitions ****************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetLocation", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::AGX_WireWinch_FL_eventSetLocation_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::AGX_WireWinch_FL_eventSetLocation_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetLocation)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_STRUCT(FVector,Z_Param_InLocation);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetLocation(Z_Param_Winch,Z_Param_InLocation);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetLocation *************************************

// ********** Begin Class UAGX_WireWinch_FL Function SetMotorEnabled *******************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics
{
	struct AGX_WireWinch_FL_eventSetMotorEnabled_Parms
	{
		FAGX_WireWinchRef Winch;
		bool bMotorEnabled;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetMotorEnabled constinit property declarations ***********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static void NewProp_bMotorEnabled_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_bMotorEnabled;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetMotorEnabled constinit property declarations *************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetMotorEnabled Property Definitions **********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetMotorEnabled_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
void Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_bMotorEnabled_SetBit(void* Obj)
{
	((AGX_WireWinch_FL_eventSetMotorEnabled_Parms*)Obj)->bMotorEnabled = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_bMotorEnabled = { "bMotorEnabled", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_WireWinch_FL_eventSetMotorEnabled_Parms), &Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_bMotorEnabled_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::NewProp_bMotorEnabled,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::PropPointers) < 2048);
// ********** End Function SetMotorEnabled Property Definitions ************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetMotorEnabled", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::AGX_WireWinch_FL_eventSetMotorEnabled_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::AGX_WireWinch_FL_eventSetMotorEnabled_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetMotorEnabled)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_UBOOL(Z_Param_bMotorEnabled);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetMotorEnabled(Z_Param_Winch,Z_Param_bMotorEnabled);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetMotorEnabled *********************************

// ********** Begin Class UAGX_WireWinch_FL Function SetMotorForceRange ****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics
{
	struct AGX_WireWinch_FL_eventSetMotorForceRange_Parms
	{
		FAGX_WireWinchRef Winch;
		float Min;
		float Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetMotorForceRange constinit property declarations ********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Min;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetMotorForceRange constinit property declarations **********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetMotorForceRange Property Definitions *******************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetMotorForceRange_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetMotorForceRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetMotorForceRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::PropPointers) < 2048);
// ********** End Function SetMotorForceRange Property Definitions *********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetMotorForceRange", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::AGX_WireWinch_FL_eventSetMotorForceRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::AGX_WireWinch_FL_eventSetMotorForceRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetMotorForceRange)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Min);
	P_GET_PROPERTY(FFloatProperty,Z_Param_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetMotorForceRange(Z_Param_Winch,Z_Param_Min,Z_Param_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetMotorForceRange ******************************

// ********** Begin Class UAGX_WireWinch_FL Function SetPulledInLength *****************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics
{
	struct AGX_WireWinch_FL_eventSetPulledInLength_Parms
	{
		FAGX_WireWinchRef Winch;
		float InPulledInLength;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetPulledInLength constinit property declarations *********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_InPulledInLength;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetPulledInLength constinit property declarations ***********************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetPulledInLength Property Definitions ********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetPulledInLength_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::NewProp_InPulledInLength = { "InPulledInLength", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetPulledInLength_Parms, InPulledInLength), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::NewProp_InPulledInLength,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::PropPointers) < 2048);
// ********** End Function SetPulledInLength Property Definitions **********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetPulledInLength", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::AGX_WireWinch_FL_eventSetPulledInLength_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::AGX_WireWinch_FL_eventSetPulledInLength_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetPulledInLength)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_PROPERTY(FFloatProperty,Z_Param_InPulledInLength);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetPulledInLength(Z_Param_Winch,Z_Param_InPulledInLength);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetPulledInLength *******************************

// ********** Begin Class UAGX_WireWinch_FL Function SetRotation ***********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics
{
	struct AGX_WireWinch_FL_eventSetRotation_Parms
	{
		FAGX_WireWinchRef Winch;
		FRotator InRotation;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetRotation constinit property declarations ***************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FStructPropertyParams NewProp_InRotation;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetRotation constinit property declarations *****************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetRotation Property Definitions **************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetRotation_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::NewProp_InRotation = { "InRotation", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetRotation_Parms, InRotation), Z_Construct_UScriptStruct_FRotator, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::NewProp_InRotation,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::PropPointers) < 2048);
// ********** End Function SetRotation Property Definitions ****************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetRotation", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::AGX_WireWinch_FL_eventSetRotation_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04822401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::AGX_WireWinch_FL_eventSetRotation_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetRotation)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_STRUCT(FRotator,Z_Param_InRotation);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetRotation(Z_Param_Winch,Z_Param_InRotation);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetRotation *************************************

// ********** Begin Class UAGX_WireWinch_FL Function SetTargetSpeed ********************************
struct Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics
{
	struct AGX_WireWinch_FL_eventSetTargetSpeed_Parms
	{
		FAGX_WireWinchRef Winch;
		float InTargetSpeed;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "Wire Winch" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
	};
#endif // WITH_METADATA

// ********** Begin Function SetTargetSpeed constinit property declarations ************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Winch;
	static const UECodeGen_Private::FFloatPropertyParams NewProp_InTargetSpeed;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetTargetSpeed constinit property declarations **************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetTargetSpeed Property Definitions ***********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::NewProp_Winch = { "Winch", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetTargetSpeed_Parms, Winch), Z_Construct_UScriptStruct_FAGX_WireWinchRef, METADATA_PARAMS(0, nullptr) }; // 2929077168
const UECodeGen_Private::FFloatPropertyParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::NewProp_InTargetSpeed = { "InTargetSpeed", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Float, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_WireWinch_FL_eventSetTargetSpeed_Parms, InTargetSpeed), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::NewProp_Winch,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::NewProp_InTargetSpeed,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::PropPointers) < 2048);
// ********** End Function SetTargetSpeed Property Definitions *************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_WireWinch_FL, nullptr, "SetTargetSpeed", 	Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::AGX_WireWinch_FL_eventSetTargetSpeed_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04022401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::AGX_WireWinch_FL_eventSetTargetSpeed_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_WireWinch_FL::execSetTargetSpeed)
{
	P_GET_STRUCT(FAGX_WireWinchRef,Z_Param_Winch);
	P_GET_PROPERTY(FFloatProperty,Z_Param_InTargetSpeed);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_WireWinch_FL::SetTargetSpeed(Z_Param_Winch,Z_Param_InTargetSpeed);
	P_NATIVE_END;
}
// ********** End Class UAGX_WireWinch_FL Function SetTargetSpeed **********************************

// ********** Begin Class UAGX_WireWinch_FL ********************************************************
FClassRegistrationInfo Z_Registration_Info_UClass_UAGX_WireWinch_FL;
UClass* UAGX_WireWinch_FL::GetPrivateStaticClass()
{
	using TClass = UAGX_WireWinch_FL;
	if (!Z_Registration_Info_UClass_UAGX_WireWinch_FL.InnerSingleton)
	{
		GetPrivateStaticClassBody(
			TClass::StaticPackage(),
			TEXT("AGX_WireWinch_FL"),
			Z_Registration_Info_UClass_UAGX_WireWinch_FL.InnerSingleton,
			StaticRegisterNativesUAGX_WireWinch_FL,
			sizeof(TClass),
			alignof(TClass),
			TClass::StaticClassFlags,
			TClass::StaticClassCastFlags(),
			TClass::StaticConfigName(),
			(UClass::ClassConstructorType)InternalConstructor<TClass>,
			(UClass::ClassVTableHelperCtorCallerType)InternalVTableHelperCtorCaller<TClass>,
			UOBJECT_CPPCLASS_STATICFUNCTIONS_FORCLASS(TClass),
			&TClass::Super::StaticClass,
			&TClass::WithinClass::StaticClass
		);
	}
	return Z_Registration_Info_UClass_UAGX_WireWinch_FL.InnerSingleton;
}
UClass* Z_Construct_UClass_UAGX_WireWinch_FL_NoRegister()
{
	return UAGX_WireWinch_FL::GetPrivateStaticClass();
}
struct Z_Construct_UClass_UAGX_WireWinch_FL_Statics
{
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Class_MetaDataParams[] = {
		{ "Comment", "/**\n * Blueprint function library for the Wire Winch. Mostly conversions between float and double.\n * Required because structs can't have Blueprint Callable functions.\n */" },
		{ "IncludePath", "Wire/AGX_WireWinch.h" },
		{ "ModuleRelativePath", "Public/Wire/AGX_WireWinch.h" },
		{ "ToolTip", "Blueprint function library for the Wire Winch. Mostly conversions between float and double.\nRequired because structs can't have Blueprint Callable functions." },
	};
#endif // WITH_METADATA

// ********** Begin Class UAGX_WireWinch_FL constinit property declarations ************************
// ********** End Class UAGX_WireWinch_FL constinit property declarations **************************
	static constexpr UE::CodeGen::FClassNativeFunction Funcs[] = {
		{ .NameUTF8 = UTF8TEXT("GetBodyAttachment"), .Pointer = &UAGX_WireWinch_FL::execGetBodyAttachment },
		{ .NameUTF8 = UTF8TEXT("GetBrakeForceRangeMax"), .Pointer = &UAGX_WireWinch_FL::execGetBrakeForceRangeMax },
		{ .NameUTF8 = UTF8TEXT("GetBrakeForceRangeMin"), .Pointer = &UAGX_WireWinch_FL::execGetBrakeForceRangeMin },
		{ .NameUTF8 = UTF8TEXT("GetCurrentSpeed"), .Pointer = &UAGX_WireWinch_FL::execGetCurrentSpeed },
		{ .NameUTF8 = UTF8TEXT("GetLocation"), .Pointer = &UAGX_WireWinch_FL::execGetLocation },
		{ .NameUTF8 = UTF8TEXT("GetMotorForceRangeMax"), .Pointer = &UAGX_WireWinch_FL::execGetMotorForceRangeMax },
		{ .NameUTF8 = UTF8TEXT("GetMotorForceRangeMin"), .Pointer = &UAGX_WireWinch_FL::execGetMotorForceRangeMin },
		{ .NameUTF8 = UTF8TEXT("GetPulledInLength"), .Pointer = &UAGX_WireWinch_FL::execGetPulledInLength },
		{ .NameUTF8 = UTF8TEXT("GetRotation"), .Pointer = &UAGX_WireWinch_FL::execGetRotation },
		{ .NameUTF8 = UTF8TEXT("GetTargetSpeed"), .Pointer = &UAGX_WireWinch_FL::execGetTargetSpeed },
		{ .NameUTF8 = UTF8TEXT("HasWire"), .Pointer = &UAGX_WireWinch_FL::execHasWire },
		{ .NameUTF8 = UTF8TEXT("IsBrakeEnabled"), .Pointer = &UAGX_WireWinch_FL::execIsBrakeEnabled },
		{ .NameUTF8 = UTF8TEXT("IsMotorEnabled"), .Pointer = &UAGX_WireWinch_FL::execIsMotorEnabled },
		{ .NameUTF8 = UTF8TEXT("MakeRef"), .Pointer = &UAGX_WireWinch_FL::execMakeRef },
		{ .NameUTF8 = UTF8TEXT("SetBodyAttachment"), .Pointer = &UAGX_WireWinch_FL::execSetBodyAttachment },
		{ .NameUTF8 = UTF8TEXT("SetBrakeEnabled"), .Pointer = &UAGX_WireWinch_FL::execSetBrakeEnabled },
		{ .NameUTF8 = UTF8TEXT("SetBrakeForceRange"), .Pointer = &UAGX_WireWinch_FL::execSetBrakeForceRange },
		{ .NameUTF8 = UTF8TEXT("SetLocation"), .Pointer = &UAGX_WireWinch_FL::execSetLocation },
		{ .NameUTF8 = UTF8TEXT("SetMotorEnabled"), .Pointer = &UAGX_WireWinch_FL::execSetMotorEnabled },
		{ .NameUTF8 = UTF8TEXT("SetMotorForceRange"), .Pointer = &UAGX_WireWinch_FL::execSetMotorForceRange },
		{ .NameUTF8 = UTF8TEXT("SetPulledInLength"), .Pointer = &UAGX_WireWinch_FL::execSetPulledInLength },
		{ .NameUTF8 = UTF8TEXT("SetRotation"), .Pointer = &UAGX_WireWinch_FL::execSetRotation },
		{ .NameUTF8 = UTF8TEXT("SetTargetSpeed"), .Pointer = &UAGX_WireWinch_FL::execSetTargetSpeed },
	};
	static UObject* (*const DependentSingletons[])();
	static constexpr FClassFunctionLinkInfo FuncInfo[] = {
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetBodyAttachment, "GetBodyAttachment" }, // 1825766628
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMax, "GetBrakeForceRangeMax" }, // 4184597170
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetBrakeForceRangeMin, "GetBrakeForceRangeMin" }, // 534424216
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetCurrentSpeed, "GetCurrentSpeed" }, // 3048968756
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetLocation, "GetLocation" }, // 3907256892
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMax, "GetMotorForceRangeMax" }, // 634774469
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetMotorForceRangeMin, "GetMotorForceRangeMin" }, // 1367732454
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetPulledInLength, "GetPulledInLength" }, // 1960877465
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetRotation, "GetRotation" }, // 448713272
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_GetTargetSpeed, "GetTargetSpeed" }, // 742139898
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_HasWire, "HasWire" }, // 411056592
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_IsBrakeEnabled, "IsBrakeEnabled" }, // 1766432155
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_IsMotorEnabled, "IsMotorEnabled" }, // 539508058
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_MakeRef, "MakeRef" }, // 1918619915
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetBodyAttachment, "SetBodyAttachment" }, // 2957080426
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeEnabled, "SetBrakeEnabled" }, // 1211275300
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetBrakeForceRange, "SetBrakeForceRange" }, // 2277955556
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetLocation, "SetLocation" }, // 1990589979
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorEnabled, "SetMotorEnabled" }, // 1145260349
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetMotorForceRange, "SetMotorForceRange" }, // 383496603
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetPulledInLength, "SetPulledInLength" }, // 3330491662
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetRotation, "SetRotation" }, // 1989496972
		{ &Z_Construct_UFunction_UAGX_WireWinch_FL_SetTargetSpeed, "SetTargetSpeed" }, // 708695989
	};
	static_assert(UE_ARRAY_COUNT(FuncInfo) < 2048);
	static constexpr FCppClassTypeInfoStatic StaticCppClassTypeInfo = {
		TCppClassTypeTraits<UAGX_WireWinch_FL>::IsAbstract,
	};
	static const UECodeGen_Private::FClassParams ClassParams;
}; // struct Z_Construct_UClass_UAGX_WireWinch_FL_Statics
UObject* (*const Z_Construct_UClass_UAGX_WireWinch_FL_Statics::DependentSingletons[])() = {
	(UObject* (*)())Z_Construct_UClass_UBlueprintFunctionLibrary,
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_WireWinch_FL_Statics::DependentSingletons) < 16);
const UECodeGen_Private::FClassParams Z_Construct_UClass_UAGX_WireWinch_FL_Statics::ClassParams = {
	&UAGX_WireWinch_FL::StaticClass,
	nullptr,
	&StaticCppClassTypeInfo,
	DependentSingletons,
	FuncInfo,
	nullptr,
	nullptr,
	UE_ARRAY_COUNT(DependentSingletons),
	UE_ARRAY_COUNT(FuncInfo),
	0,
	0,
	0x001000A0u,
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_WireWinch_FL_Statics::Class_MetaDataParams), Z_Construct_UClass_UAGX_WireWinch_FL_Statics::Class_MetaDataParams)
};
void UAGX_WireWinch_FL::StaticRegisterNativesUAGX_WireWinch_FL()
{
	UClass* Class = UAGX_WireWinch_FL::StaticClass();
	FNativeFunctionRegistrar::RegisterFunctions(Class, MakeConstArrayView(Z_Construct_UClass_UAGX_WireWinch_FL_Statics::Funcs));
}
UClass* Z_Construct_UClass_UAGX_WireWinch_FL()
{
	if (!Z_Registration_Info_UClass_UAGX_WireWinch_FL.OuterSingleton)
	{
		UECodeGen_Private::ConstructUClass(Z_Registration_Info_UClass_UAGX_WireWinch_FL.OuterSingleton, Z_Construct_UClass_UAGX_WireWinch_FL_Statics::ClassParams);
	}
	return Z_Registration_Info_UClass_UAGX_WireWinch_FL.OuterSingleton;
}
UAGX_WireWinch_FL::UAGX_WireWinch_FL(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer) {}
DEFINE_VTABLE_PTR_HELPER_CTOR_NS(, UAGX_WireWinch_FL);
UAGX_WireWinch_FL::~UAGX_WireWinch_FL() {}
// ********** End Class UAGX_WireWinch_FL **********************************************************

// ********** Begin Registration *******************************************************************
struct Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics
{
	static constexpr FStructRegisterCompiledInInfo ScriptStructInfo[] = {
		{ FAGX_WireWinchSettings::StaticStruct, Z_Construct_UScriptStruct_FAGX_WireWinchSettings_Statics::NewStructOps, TEXT("AGX_WireWinchSettings"),&Z_Registration_Info_UScriptStruct_FAGX_WireWinchSettings, CONSTRUCT_RELOAD_VERSION_INFO(FStructReloadVersionInfo, sizeof(FAGX_WireWinchSettings), 2009274141U) },
		{ FAGX_WireWinch::StaticStruct, Z_Construct_UScriptStruct_FAGX_WireWinch_Statics::NewStructOps, TEXT("AGX_WireWinch"),&Z_Registration_Info_UScriptStruct_FAGX_WireWinch, CONSTRUCT_RELOAD_VERSION_INFO(FStructReloadVersionInfo, sizeof(FAGX_WireWinch), 1182176698U) },
		{ FAGX_WireWinchRef::StaticStruct, Z_Construct_UScriptStruct_FAGX_WireWinchRef_Statics::NewStructOps, TEXT("AGX_WireWinchRef"),&Z_Registration_Info_UScriptStruct_FAGX_WireWinchRef, CONSTRUCT_RELOAD_VERSION_INFO(FStructReloadVersionInfo, sizeof(FAGX_WireWinchRef), 2929077168U) },
	};
	static constexpr FClassRegisterCompiledInInfo ClassInfo[] = {
		{ Z_Construct_UClass_UAGX_WireWinch_FL, UAGX_WireWinch_FL::StaticClass, TEXT("UAGX_WireWinch_FL"), &Z_Registration_Info_UClass_UAGX_WireWinch_FL, CONSTRUCT_RELOAD_VERSION_INFO(FClassReloadVersionInfo, sizeof(UAGX_WireWinch_FL), 1932545996U) },
	};
}; // Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics 
static FRegisterCompiledInInfo Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_2564062984{
	TEXT("/Script/AGXUnreal"),
	Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics::ClassInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics::ClassInfo),
	Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics::ScriptStructInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_GitLab_Runner_builds_9YzzThLq_0_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Wire_AGX_WireWinch_h__Script_AGXUnreal_Statics::ScriptStructInfo),
	nullptr, 0,
};
// ********** End Registration *********************************************************************

PRAGMA_ENABLE_DEPRECATION_WARNINGS
