%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Urdf()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Urdf()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Urdf/Urdf_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Urdf(prefix)
%rename(prefix ## PackagePath) openplx::Urdf::PackagePath;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Urdf()
%shared_ptr(openplx::Urdf::PackagePath);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Urdf()
%typemap(out) std::shared_ptr<openplx::Urdf::PackagePath> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Urdf()
%template(Urdf_PackagePath_Vector) std::vector<std::shared_ptr<openplx::Urdf::PackagePath>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Urdf::PackagePath>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Urdf::PackagePath>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Urdf::PackagePath>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Urdf::PackagePath>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Urdf::PackagePath>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Urdf::PackagePath>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Urdf()
%include "openplx/Urdf/PackagePath.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Urdf()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Urdf()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Urdf/Urdf_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Urdf()
%import "Urdf.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Urdf()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%include <python/Visuals/Visuals.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Visuals();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Urdf()
%import "Math.i"
%import "Physics.i"
%import "Physics3D.i"
%import "Visuals.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Urdf(prefix)
OPENPLX_SWIG_NS_RENAMES_Urdf(prefix);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Urdf()
OPENPLX_SWIG_NS_SHARED_POINTERS_Urdf();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Urdf()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Urdf();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Urdf()
OPENPLX_SWIG_NS_VECTORS_Urdf();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Urdf()
OPENPLX_SWIG_NS_INCLUDES_Urdf();
%enddef

