%module(package="openplx") Robotics
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%import(module="Simulation") <python/Simulation/SimulationModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Robotics/Robotics_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Robotics/Robotics.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Robotics(Robotics_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Robotics();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Robotics();
OPENPLX_SWIG_BUNDLE_VECTORS_Robotics();
%include "openplx/Robotics/EndEffectors/SixDofSuctionCupJoint.h"
%include "openplx/Robotics/EndEffectors/SuctionCup.h"
%include "openplx/Robotics/Joints/Joint.h"
%include "openplx/Robotics/EndEffectors/SuctionCupElastoDynamics.h"
%include "openplx/Robotics/EndEffectors/VacuumSystem.h"
%include "openplx/Robotics/Signals/RobotOutput.h"
%include "openplx/Robotics/Joints/JointData.h"
%include "openplx/Robotics/Signals/RobotInputSignal.h"
%include "openplx/Robotics/Kinematics/ElementaryTransform.h"
%include "openplx/Robotics/Kinematics/FromETS.h"
%include "openplx/Robotics/Links/LinkData.h"
%include "openplx/Robotics/Links/RigidLink.h"
%include "openplx/Robotics/Signals/RobotOutputSignal.h"
%include "openplx/Robotics/Robots/Robot.h"
%include "openplx/Robotics/Signals/RobotInput.h"
%include "openplx/Robotics/Robots/SerialManipulatorData.h"
%include "openplx/Robotics/Signals/Sensor.h"
%include "openplx/Robotics/Signals/SensorValues.h"
%include "openplx/Robotics/Joints/ActuatedJoint.h"
%include "openplx/Robotics/Joints/FixedJoint.h"
%include "openplx/Robotics/EndEffectors/SixDofSuctionCup.h"
%include "openplx/Robotics/EndEffectors/ConstantVacuumSystem.h"
%include "openplx/Robotics/EndEffectors/VacuumGripper.h"
%include "openplx/Robotics/Joints/HingeJointData.h"
%include "openplx/Robotics/Links/RigidTriMeshLink.h"
%include "openplx/Robotics/Links/RigidBoxLink.h"
%include "openplx/Robotics/Joints/CoupledJointDriveTrain.h"
%include "openplx/Robotics/Joints/FlexibleJointDriveTrain.h"
%include "openplx/Robotics/Joints/HingeJoint.h"
%include "openplx/Robotics/Joints/PrismaticJoint.h"
%include "openplx/Robotics/Joints/FlexibleJointData.h"
%include "openplx/Robotics/Joints/FlexibleJointTrait.h"
%include "openplx/Robotics/Joints/TorqueHingeJoint.h"
%include "openplx/Robotics/Robots/SixAxisSerialManipulator.h"
%include "openplx/Robotics/Joints/PositionHingeJoint.h"
%include "openplx/Robotics/Joints/VelocityHingeJoint.h"
%include "openplx/Robotics/Joints/FlexibleAngularVelocityJoint.h"
%include "openplx/Robotics/Joints/FlexibleTorqueJoint.h"
