%module(package="openplx") Physics1D
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Physics1D(Physics1D_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics1D();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics1D();
OPENPLX_SWIG_BUNDLE_VECTORS_Physics1D();
%include "openplx/Physics1D/Bodies/Kinematics.h"
%include "openplx/Physics1D/Bodies/Inertia.h"
%include "openplx/Physics1D/Interactions/Mate.h"
%include "openplx/Physics1D/Interactions/MateConnector.h"
%include "openplx/Physics1D/Interactions/VelocityMotor.h"
%include "openplx/Physics1D/Bodies/RotationalKinematics.h"
%include "openplx/Physics1D/Bodies/LinearKinematics.h"
%include "openplx/Physics1D/Bodies/Body.h"
%include "openplx/Physics1D/Interactions/LinearConnector.h"
%include "openplx/Physics1D/Interactions/RotationalConnector.h"
%include "openplx/Physics1D/Interactions/RotationalVelocityMotor.h"
%include "openplx/Physics1D/Bodies/LinearBody.h"
%include "openplx/Physics1D/Bodies/RotationalBody.h"
