#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Wheels/Base.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Interactions/Lock.h>
#include <openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h>
#include <openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ElasticWheel */
namespace openplx::Vehicles::Wheels {
    class OPENPLX_Vehicles_BUNDLE_EXPORT ElasticWheel : public openplx::Vehicles::Wheels::Base {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_tire;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> m_tire_mate;
            std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping> m_dissipation;
            std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility> m_flexibility;

        public:
            ElasticWheel();
            virtual ~ElasticWheel();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> tire() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> tire_mate() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping> dissipation() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility> flexibility() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
