#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
/* Generated code for model Base */
namespace openplx::Vehicles::Steering::Interfaces {
    /**
     * Base trait for various steering mechanism interfaces,
     * which have a knuckle angle and length in common.
     *
     * The interfaces are both intended for Kinematic coupling
     * as well as linked steering mechanism.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT Base {
        public:
            Base();
            virtual ~Base();
            virtual double knuckle_angle() const = 0;
            virtual double knuckle_length() const = 0;
    };
}
