#pragma once

#include <stack>
#include <openplx/NodeVisitor.h>

namespace openplx {
    class TypeInferrer : private NodeVisitor {
        public:
            TypeInferrer(
                PrimitiveTypePtr primitive_type_real,
                PrimitiveTypePtr primitive_type_string,
                PrimitiveTypePtr primitive_type_bool,
                PrimitiveTypePtr primitive_type_int,
                PrimitiveTypePtr primitive_type_none);
            TypeInferrer();
            TypePtr inferType(const ExprPtr& expression);
        private:
            void visitConstant(const ConstantPtr& constant) override;
            std::stack<TypePtr> m_stack;
            PrimitiveTypePtr m_primitive_type_real;
            PrimitiveTypePtr m_primitive_type_string;
            PrimitiveTypePtr m_primitive_type_bool;
            PrimitiveTypePtr m_primitive_type_int;
            PrimitiveTypePtr m_primitive_type_none;
    };
}
