
#pragma once

#include <vector>
#include <memory>
#include <openplx/Token.h>
#include <openplx/NodeVisitor.h>

namespace openplx
{
    class ErrorReporter;
    class Error;
    /**
     * Implements pass 1 of semantic analysis as described in developer/BrickSemanticAnalysis.md
     */
    class TypeBinder : private NodeVisitor
    {
        public:

            explicit TypeBinder(std::shared_ptr<ErrorReporter> error_reporter);

            void bind(const DocPtr& document);

        private:

            TypePtr findType(const std::vector<Token>& type_segments);

            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitVarAssignment(const VarAssignPtr &var_assignment) override;

            void visitMethodDeclaration(const MethodDeclPtr &method_declaration) override;

            void visitParameter(const ParamPtr &parameter) override;

            void visitOperatorOverload(const OpOverloadPtr &op_overload) override;

            void visitTraitImpl(const TraitImplPtr& trait) override;

        private:

            template<typename ErrorType>
            void reportError(const Token& first_token, const Token& last_token);
            template<typename ErrorType>
            void reportError(const Token& token);
            template<typename ErrorType>
            void reportError(const std::vector<Token>& segments);
            void reportError(std::shared_ptr<Error>&& error);

            PrimitiveTypePtr m_primitive_type_int;
            PrimitiveTypePtr m_primitive_type_real;
            PrimitiveTypePtr m_primitive_type_bool;
            PrimitiveTypePtr m_primitive_type_string;
            PrimitiveTypePtr m_primitive_type_blob;

            std::shared_ptr<ErrorReporter> m_error_reporter;

            DocPtr m_document;
            ModelDeclPtr m_model;
    };
}
