
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/TreeNode.h>

namespace openplx
{
    class TraitImpl : public Node, public std::enable_shared_from_this<TraitImpl>
    {
        public:
            /* Factories */
            static TraitImplPtr create(const std::vector<Token>& trait_segments);

            /* Overrides */
            TraitImplPtr asTraitImpl() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Trait model */
            const std::vector<Token>& getTraitSegments() const;
            ModelDeclPtr getTraitModel() const;
            void setTraitModel(ModelDeclPtr trait_model);

            /* Parent */
            TraitImplPtr getParent() const;
            void setParent(TraitImplPtr parent);

            /* Annotations */
            const std::vector<AnnotationPtr>& getAnnotations() const;
            void appendToAnnotations(AnnotationPtr annotation);

            /* Members */
            const std::vector<NodePtr>& getMembers() const;
            void appendToMembers(NodePtr member);

            /* Source id */
            std::string getSourceIdOrDefault() const;

            /* Owning model */
            ModelDeclPtr getOwningModel() const;
            void setOwningModel(ModelDeclPtr owning_model);

            /* Layout */
            void layout(line_t line, col_t column);

        private:
            TraitImpl();
            std::vector<Token> m_trait_segments;
            ModelDeclPtr m_trait_model;
            TraitImplPtr m_parent;
            std::vector<AnnotationPtr> m_annotations;
            std::vector<NodePtr> m_members;
            ModelDeclPtr m_owning_model;
    };
}
