
#pragma once

#include <memory>
#include <string>
#include <openplx/Expression.h>
#include <openplx/VarDeclaration.h>
#include <openplx/Type.h>
#include <openplx/Node.h>

namespace openplx
{
    class SortedAssignment : public std::enable_shared_from_this<SortedAssignment>
    {
        public:
            static SortedAssignmentPtr create(
                const std::vector<NodePtr>& this_path,
                const std::vector<NodePtr>& target_path,
                int64_t degree,
                int64_t depth,
                int64_t depth_of_first_becomes,
                bool valid,
                ExprPtr value,
                NodePtr source);

            /* This path */
            const std::vector<NodePtr>& getThisPath() const;

            /* Target path */
            const std::vector<NodePtr>& getTargetPath() const;

            /* Degree */
            int64_t getDegree() const;
            void updateDegree(int64_t degree);

            /* Depth */
            int64_t getDepth() const;
            void setDepth(int64_t depth);

            /* Depth of first becomes */
            int64_t getDepthOfFirstBecomes() const;
            void setDepthOfFirstBecomes(int64_t depth_of_first_becomes);

            /* Valid */
            bool isValid() const;
            void setValid(bool valid);

            /* Value */
            ExprPtr getValue() const;
            void setValue(ExprPtr value);

            /* Source */
            NodePtr getSource() const;
            void setSource(NodePtr source);

            /* Utility */
            ModelDeclPtr getOwningModel();
            static bool samePathAs(const std::vector<NodePtr>& left, const std::vector<NodePtr>& right);
            static bool shadows(const std::vector<NodePtr>& left, const std::vector<NodePtr>& right);
            static bool shadowedBy(const std::vector<NodePtr>& left, const std::vector<NodePtr>& right);
            static TypePtr resolveTypeOrNull(const NodePtr& node);
            static std::string resolveName(const NodePtr& node);
            static std::string targetPathAsString(const std::vector<NodePtr>& path);
            bool samePathAs(const std::vector<NodePtr>& path);
            bool shadows(const std::vector<NodePtr>& path);
            bool shadowedBy(const std::vector<NodePtr>& path);
            std::string targetPathAsString() const;
            TypePtr getLastType() const;
            TypePtr getType(size_t index) const;

            void addEdge(SortedAssignmentPtr edge);
            const std::vector<SortedAssignmentPtr> getEdges() const;

        private:
            SortedAssignment();
            std::vector<NodePtr> m_this_path;
            std::vector<NodePtr> m_target_path;
            std::vector<SortedAssignmentPtr> m_edges;
            int64_t m_degree;
            int64_t m_depth;
            int64_t m_depth_of_first_becomes;
            bool m_valid;
            ExprPtr m_value;
            NodePtr m_source;
    };
}
